<h2>Why is this an issue?</h2>
<p>When an object is created with a setter for a property but without a getter for that property, the property is inaccessible and is thus
useless.</p>
<p>This rule also enforces the reverse situation (getter but no setter).</p>
<h3>Noncompliant code example</h3>

```ts
var obj = {
    set foo(value) {
        this.fooval = value;
    }
};
```
<h3>Compliant solution</h3>

```ts
var obj = {
    set foo(value) {
        this.fooval = value;
    },
    get foo() {
        return this.fooval;
    }
};
```
<p>or</p>

```ts
var obj = {
    setFoo(value) {    // a standard method, not a setter
        this.fooval = value;
    }
};
```