<h2>Why is this an issue?</h2>
<p>In TypeScript, intersections are used to combine multiple types into a single one. An intersection type is represented using the ampersand symbol
<code>&amp;</code>. It allows you to combine multiple types into a single type that includes all the properties and methods from each type, thus
creating more flexible and powerful type definitions.</p>
<p>However, some of the basic types of TypeScript should not be used with intersections:</p>
<ul>
  <li> The <code>never</code> type represents the type of values that never occur. Intersecting any type with <code>never</code> will always result in
  type <code>never</code>. </li>
  <li> The <code>any</code> type allows to opt-out of type checking during compilation. Expressions of type <code>any</code> allow you to access
  arbitrary properties, even ones that don’t exist. <code>any</code> comes at the cost of losing type safety, which is one of the main motivations for
  using TypeScript. Avoid using <code>any</code> when not necessary. Intersecting any type with <code>any</code> will always result in type
  <code>any</code>. </li>
  <li> The <code>undefined</code> and <code>null</code> types are the types for their respective value. Intersecting any type with them will always
  result in type <code>never</code>. </li>
  <li> The <code>void</code> type implies the absence of a type. Intersecting any type with <code>void</code> will always result in type
  <code>never</code>. </li>
</ul>
<p>Additionally, an intersection with a type without members (for example, <code>{}</code>) doesn’t change the resulting type, is redundant, and can
be safely removed from the intersection.</p>

```ts
type Foo = T & null; // Noncompliant: 'Foo' is always 'never'

type Bar = T & any; // Noncompliant: 'Bar' is always 'any'

type Baz = T & U & {}; // Noncompliant: '{}' has no members and is redundant
```
<p>Use consistent types that accurately reflect the domain of values of the defined data type.</p>

```ts
type Foo = T | null;

type Bar = T & U;

type Baz = T & U;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/unions-and-intersections.html#intersection-types">Intersection
  Types</a> </li>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/basic-types.html#never"><code>never</code></a> </li>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/basic-types.html#any"><code>any</code></a> </li>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/basic-types.html#null-and-undefined"><code>null</code> and
  <code>undefined</code></a> </li>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/basic-types.html#void"><code>void</code></a> </li>
</ul>