<h2>Why is this an issue?</h2>
<p>In TypeScript, optional and default parameters are features that enhance the flexibility and usability of functions by allowing you to define
parameters that can be omitted during function calls or have default values assigned to them when not provided explicitly:</p>
<ul>
  <li> Optional parameters are denoted by adding a question mark (<code>?</code>) after the parameter name in the function declaration. These
  parameters can be omitted when calling the function, and TypeScript will assign them a value of undefined if they are not provided. </li>
  <li> Default parameters are used to assign a default value to a parameter in case the caller does not provide a value for that parameter. Default
  values are specified in the function declaration using the assignment operator (<code>=</code>) followed by the default value. </li>
</ul>
<p>When a parameter is defined as optional, it automatically allows that parameter to be omitted during function calls. If you explicitly pass
<code>undefined</code> as the value for an optional parameter, it contradicts the purpose of making the parameter optional, making the code less
readable and maintainable.</p>
<p>Similarly, when a parameter has a default value, it means that if the caller omits the argument during function calls, the default value will be
used automatically. There is no need to pass <code>undefined</code> explicitly for default parameters, except when they come before a required
parameter.</p>
<p>This rule checks that the last argument of a function call is not redundant with regard to the function’s signature.</p>

```ts
function foo(x: number, y: string = "default", z?: number) {
  // ...
}

foo(42, undefined); // Noncompliant: 'undefined' is redundant
foo(42, undefined, undefined); // Noncompliant: Both 'undefined' are redundant
foo(42, undefined, 5); // Compliant: 'undefined' is required to get the second parameter's default value
```
<p>Instead of explicitly passing <code>undefined</code>, simply omit the optional argument when calling the function to let TypeScript handle the
default value correctly.</p>

```ts
function foo(x: number, y: string = "default", z?: number) {
  // ...
}

foo(42);
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/2/functions.html#optional-parameters">Optional Parameters</a>
  </li>
</ul>