<h2>Why is this an issue?</h2>
<p>TypeScript provides both numeric and string-based enums. Members of enums can be assigned strings, numbers, both, or none, which default to numbers
starting from zero. Although it is possble to mix the types of enum member values, it is generally considered confusing and a bad practice.</p>
<p>Enum members should be consistently assigned values of the same type, that is, strings or numbers.</p>
<h2>How to fix it</h2>
<p>Either assign all enum members with values of the same type or none of them.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
enum Color {
    Red, // 0 by default
    Green = 1,
    Blue = "blue"
}
```
<h4>Compliant solution</h4>

```ts
enum Color {
    Red = "red",
    Green = "green",
    Blue = "blue"
}
```
<h4>Noncompliant code example</h4>

```ts
enum Status {
    SYN = 0,
    SYN_ACK,
    ACK = "ack"
}
```
<h4>Compliant solution</h4>

```ts
enum Direction {
    SYN,
    SYN_ACK,
    ACK
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/enums.html">Enums</a> </li>
</ul>