/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.accounts;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.ServiceUtils;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.EConnectorType;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.EPasswordType;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.core.analysis.configuration.model.ESystemType;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackendIndex;
import com.teamscale.service.accounts.ReplacingExternalCredentialsProvider;
import com.teamscale.service.base.ElementListServiceBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.permissions.PermissionFilterUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@Path(value="api/external-accounts")
public class ExternalAccountsService
extends ElementListServiceBase<ExternalCredentialsData> {
    static Consumer<ConfigurationInitializationContext> validateConnectorsTestingHook = null;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MASKED_PASSWORD = "_#_mskd_#_";
    private static final String SKIP_CONNECTOR_VALIDATION = "skip-connector-validation";

    @GET
    @Operation(summary="Get all external accounts", description="Retrieves all available external accounts in the system.", tags={"External Accounts"})
    @RequiresNoPermission(description="No permissions needed, as the service will only return credentials visible to current user.")
    public List<ExternalCredentialsData> getAllExternalAccounts() throws StorageException {
        List<ExternalCredentials> visibleExternalCredentials = PermissionFilterUtils.getVisibleExternalCredentials(this.getPermissions(), this.openGlobalIndex(ExternalCredentialsIndex.class));
        Map<String, User> usernameToUserMapping = ExternalAccountsService.getUsernameToUserMapping(visibleExternalCredentials.stream().map(ExternalCredentials::getLastChangeUser).collect(Collectors.toSet()), this.openGlobalIndex(UserIndex.class));
        return CollectionUtils.map(visibleExternalCredentials, externalCredentials -> new ExternalCredentialsData((ExternalCredentials)externalCredentials, usernameToUserMapping));
    }

    @GET
    @RequiresNoPermission(description="No permissions needed, as the service should check whether the credentials already exists for every user to prohibit overwriting credentials not visible for the current user")
    @Operation(summary="Check if external accounts exist", description="Checks if the external accounts identified by the given name exist.", tags={"External Accounts"}, responses={@ApiResponse(responseCode="404", description="External accounts with given name do not exist.")})
    @Path(value="{externalCredentialsName}")
    public ExternalCredentialsData externalAccountsExist(@Parameter(description="Name of the external accounts to check") @PathParam(value="externalCredentialsName") String externalCredentialsName) throws StorageException {
        return (ExternalCredentialsData)this.getElementWithExistsCheck(externalCredentialsName);
    }

    @DELETE
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, permissions={EBasicPermission.DELETE}, entityPathParameter="externalCredentialsName")
    @Operation(summary="Delete external accounts", description="Deletes the external accounts identified by the given name from the system", tags={"External Accounts"}, responses={@ApiResponse(responseCode="404", description="External accounts identified by the given name do not exist in the system."), @ApiResponse(responseCode="400", description="External accounts identified by the given name are used by at least one existing project."), @ApiResponse(responseCode="400", description="External accounts identified by the given name refer to an unknown connector or connector type."), @ApiResponse(responseCode="400", description="Update of external accounts rejected due to project validation error.")})
    @Path(value="{externalCredentialsName}")
    public void deleteExternalAccounts(@Parameter(description="Name of the external accounts to delete") @PathParam(value="externalCredentialsName") String externalCredentialsName, @Parameter(description="Skip connector validation for connectors using the account.") @QueryParam(value="skip-connector-validation") boolean skipValidation) throws StorageException {
        ExternalCredentialsData externalCredentials = (ExternalCredentialsData)this.getElementWithExistsCheck(externalCredentialsName);
        this.deleteExternalAccounts(externalCredentials, skipValidation);
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_EXTERNAL_TOOL_ACCOUNTS})
    @Operation(summary="Create external accounts", description="Creates new external accounts.", tags={"External Accounts"}, responses={@ApiResponse(responseCode="400", description="External accounts identified by the given name refer to an unknown connector or connector type."), @ApiResponse(responseCode="400", description="Account name in the provided credentials is null or empty."), @ApiResponse(responseCode="400", description="Account URI in the provided credentials is null or empty.")})
    public void createExternalAccounts(@RequestBody(required=true) ExternalCredentialsData newValue) throws StorageException {
        this.createElementAndPermissions(newValue);
    }

    @PUT
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, permissions={EBasicPermission.EDIT}, entityPathParameter="externalCredentialsName")
    @Operation(summary="Update external accounts", description="Updates the external accounts identified by the given name with the value in the request body.", tags={"External Accounts"}, responses={@ApiResponse(responseCode="400", description="External accounts identified by the given name refer to an unknown connector or connector type."), @ApiResponse(responseCode="400", description="Account name in the provided credentials is null or empty."), @ApiResponse(responseCode="400", description="Account URI in the provided credentials is null or empty."), @ApiResponse(responseCode="400", description="Account name in the provided external accounts is different from the account name in the existing credentials."), @ApiResponse(responseCode="400", description="Account URI in the provided credentials changed, but password was not provided.")})
    @Path(value="{externalCredentialsName}")
    public void updateExternalAccounts(@Parameter(description="Skip connector validation for connectors using the account.") @QueryParam(value="skip-connector-validation") boolean skipValidation, @RequestBody(required=true) ExternalCredentialsData newValue, @Parameter(description="Name of the old external accounts.") @PathParam(value="externalCredentialsName") String externalCredentialsName) throws StorageException, ProjectConfigurationException {
        ExternalCredentialsData externalCredentials = this.getElement(externalCredentialsName);
        this.updateExternalAccounts(externalCredentials, newValue, skipValidation);
    }

    @Override
    protected void createPermissions(ExternalCredentialsData newElement) throws StorageException {
        this.getPermissions().createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, newElement.credentialsName);
    }

    @Override
    protected ExternalCredentialsData getElement(String elementName) throws StorageException {
        ExternalCredentials externalCredentials = this.openGlobalIndex(ExternalCredentialsIndex.class).getExternalCredentials(elementName);
        if (externalCredentials == null) {
            return null;
        }
        Map<String, User> userMap = ExternalAccountsService.getUsernameToUserMapping(CollectionUtils.asHashSet((Object[])new String[]{externalCredentials.getLastChangeUser()}), this.openGlobalIndex(UserIndex.class));
        return new ExternalCredentialsData(externalCredentials, userMap);
    }

    private static Map<String, User> getUsernameToUserMapping(Collection<@Nullable String> usernames, UserIndex userIndex) throws StorageException {
        HashMap<String, User> userMapping = new HashMap<String, User>();
        for (String username : usernames) {
            if (username == null) continue;
            userMapping.put(username, userIndex.getUser(username));
        }
        return userMapping;
    }

    @Override
    protected void deleteElement(ExternalCredentialsData externalCredentials) throws StorageException {
        this.openGlobalIndex(ExternalCredentialsIndex.class).deleteExternalCredentials(this.createExternalAccountsFromData(externalCredentials));
    }

    @Override
    protected void deletePermissions(ExternalCredentialsData externalCredentials) throws StorageException {
        this.getPermissions().createPermissionModifier().removeBasicRoleInstanceAssignments(EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, externalCredentials.credentialsName);
    }

    private void updateExternalAccounts(ExternalCredentialsData oldExternalCredentials, ExternalCredentialsData newExternalCredentials, boolean skipValidation) throws StorageException {
        ExternalCredentials actualCredentials = this.createExternalAccountsFromData(newExternalCredentials);
        ExternalAccountsService.validateExternalAccounts(actualCredentials);
        ExternalAccountsService.validateExternalAccountsUpdate(oldExternalCredentials, newExternalCredentials);
        ListMap<PublicProjectId, ConnectorConfiguration> affectedConnectorsByProject = this.getAffectedConnectorsByProject(newExternalCredentials.credentialsName);
        ReplacingExternalCredentialsProvider replacingExternalCredentialsProvider = new ReplacingExternalCredentialsProvider((IExternalCredentialsProvider)this.openGlobalIndex(ExternalCredentialsIndex.class), newExternalCredentials.credentialsName, actualCredentials);
        ConfigurationInitializationContext initializationContext = new ConfigurationInitializationContext(this.getIndexLayer(), (IExternalCredentialsProvider)replacingExternalCredentialsProvider);
        if (!skipValidation) {
            this.validateConnectors(affectedConnectorsByProject, initializationContext);
        }
        try {
            if (!newExternalCredentials.uri.equals(oldExternalCredentials.uri)) {
                this.updateRepositoryToTriggerMappingIndex(affectedConnectorsByProject, initializationContext, oldExternalCredentials.uri);
            }
            this.updateElement(oldExternalCredentials, newExternalCredentials);
        }
        catch (ProjectConfigurationException | StorageException e) {
            throw new BadRequestException(e);
        }
    }

    private static void validateExternalAccountsUpdate(ExternalCredentialsData oldExternalCredentials, ExternalCredentialsData newExternalCredentials) {
        if (!oldExternalCredentials.credentialsName.equals(newExternalCredentials.credentialsName)) {
            throw new BadRequestException("Accounts can't be renamed. Delete the old account and create a new one instead.");
        }
        if (!Objects.equals(oldExternalCredentials.uri, newExternalCredentials.uri)) {
            if (MASKED_PASSWORD.equals(newExternalCredentials.username)) {
                throw new BadRequestException("For security reasons, the access and secret keys must be provided again if the uri changes.");
            }
            if (MASKED_PASSWORD.equals(newExternalCredentials.password)) {
                throw new BadRequestException("For security reasons, the password must be provided again if the uri changes.");
            }
        }
    }

    @Override
    protected void updateElement(ExternalCredentialsData oldExternalCredentialsData, ExternalCredentialsData newExternalCredentialsData) throws StorageException, BadRequestException {
        ExternalCredentials newExternalCredentials;
        ExternalCredentialsIndex credentialsIndex = this.openGlobalIndex(ExternalCredentialsIndex.class);
        ExternalCredentials oldExternalCredentials = credentialsIndex.getExternalCredentials(newExternalCredentialsData.credentialsName);
        String password = newExternalCredentialsData.password;
        String username = newExternalCredentialsData.username;
        if (oldExternalCredentials != null) {
            if (MASKED_PASSWORD.equals(newExternalCredentialsData.password)) {
                password = oldExternalCredentials.password;
            }
            if (MASKED_PASSWORD.equals(newExternalCredentialsData.username)) {
                username = oldExternalCredentials.username;
            }
        }
        if ((newExternalCredentials = this.createExternalAccountsFromData(newExternalCredentialsData, username, password)).equals((Object)oldExternalCredentials)) {
            return;
        }
        credentialsIndex.setExternalCredentials(newExternalCredentials);
    }

    @Override
    protected void createElement(ExternalCredentialsData newExternalCredentials) throws StorageException, BadRequestException {
        ExternalCredentials actualCredentials = this.createExternalAccountsFromData(newExternalCredentials);
        ExternalAccountsService.validateExternalAccounts(actualCredentials);
        this.openGlobalIndex(ExternalCredentialsIndex.class).setExternalCredentials(actualCredentials);
    }

    private static void validateExternalAccounts(ExternalCredentials newExternalCredentials) throws BadRequestException {
        if (StringUtils.isEmpty((String)newExternalCredentials.credentialsName)) {
            throw new BadRequestException("Account name can't be null or empty.");
        }
        if (StringUtils.isEmpty((String)newExternalCredentials.uri)) {
            throw new BadRequestException("Account uri can't be null or empty.");
        }
        if (!ServiceUtils.isValidServerAddress((String)newExternalCredentials.uri)) {
            throw new BadRequestException("Account uri is not valid. (Is it missing a protocol? E.g., http://, https://)");
        }
    }

    private ListMap<PublicProjectId, ConnectorConfiguration> getAffectedConnectorsByProject(String credentialsName) throws StorageException {
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        ListMap affectedConnectorsByProject = new ListMap();
        for (ProjectInfo projectInfo : projectIndex.getAllProjectInfos()) {
            ProjectConfiguration configuration;
            List<ConnectorConfiguration> connectors;
            if (projectInfo.isDeleting() || (connectors = ExternalAccountsService.getConnectorsUsingAccount(configuration = (ProjectConfiguration)((MetaIndex)this.serviceInfo.getProjectStorageSystem(projectInfo).openProjectIndex(MetaIndex.class, null)).getValue(ProjectConfiguration.class), credentialsName)).isEmpty()) continue;
            affectedConnectorsByProject.addAll((Object)projectInfo.getPrimaryPublicId(), connectors);
        }
        return affectedConnectorsByProject;
    }

    private void validateConnectors(ListMap<PublicProjectId, ConnectorConfiguration> affectedConnectorsByProject, ConfigurationInitializationContext initializationContext) {
        if (validateConnectorsTestingHook != null) {
            validateConnectorsTestingHook.accept(initializationContext);
        }
        ListMap errorsByProject = new ListMap();
        for (Map.Entry connector : affectedConnectorsByProject) {
            PublicProjectId projectId = (PublicProjectId)connector.getKey();
            List value = (List)connector.getValue();
            for (int i = 0; i < value.size(); ++i) {
                ConnectorConfiguration connectorConfiguration = (ConnectorConfiguration)value.get(i);
                try {
                    ConnectorUtils.loadAndValidateConnector((ConnectorConfiguration)connectorConfiguration, (ConfigurationInitializationContext)initializationContext, (InternalProjectId)this.getIndexLayer().resolveToInternalProjectId((IProjectId)projectId), (Integer)i);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn("Rejected update of external accounts due to project validation error.", (Throwable)e);
                    errorsByProject.add((Object)projectId, (Object)e.getMessage());
                }
            }
        }
        if (!errorsByProject.getKeys().isEmpty()) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorsByProject.collectionsToArrays(String.class)).build());
        }
    }

    private static List<ConnectorConfiguration> getConnectorsUsingAccount(ProjectConfiguration configuration, String credentialsName) {
        ArrayList<ConnectorConfiguration> affectedConnectors = new ArrayList<ConnectorConfiguration>();
        for (ConnectorConfiguration connectorConfiguration : configuration.getConnectors()) {
            String account = connectorConfiguration.getOptionValue("Account");
            if (!credentialsName.equals(account)) continue;
            affectedConnectors.add(connectorConfiguration);
        }
        return affectedConnectors;
    }

    private ExternalCredentials createExternalAccountsFromData(ExternalCredentialsData externalCredentialsData) throws BadRequestException {
        return this.createExternalAccountsFromData(externalCredentialsData, externalCredentialsData.username, externalCredentialsData.password);
    }

    private ExternalCredentials createExternalAccountsFromData(ExternalCredentialsData externalCredentialsData, String username, String password) throws BadRequestException {
        ConnectorTypeInfoData connectorTypeInfoData = externalCredentialsData.connectorTypeInfo;
        ExternalCredentials.ConnectorTypeInfo connectorTypeInfo = new ExternalCredentials.ConnectorTypeInfo();
        if (connectorTypeInfoData != null) {
            EIssueTracker connectorEnum;
            String connectorEnumName = connectorTypeInfoData.connectorEnum;
            switch (connectorTypeInfoData.connectorType) {
                default: {
                    throw new MatchException(null, null);
                }
                case ISSUE_TRACKER: {
                    EIssueTracker eIssueTracker = (EIssueTracker)EnumUtils.valueOfIgnoreCase(EIssueTracker.class, (String)connectorEnumName);
                    break;
                }
                case SOURCE_CODE_REPOSITORY: {
                    EIssueTracker eIssueTracker = (ERepositoryConnector)EnumUtils.valueOfIgnoreCase(ERepositoryConnector.class, (String)connectorEnumName);
                    break;
                }
                case SYSTEM_TYPE: {
                    EIssueTracker eIssueTracker = (ESystemType)EnumUtils.valueOfIgnoreCase(ESystemType.class, (String)connectorEnumName);
                    break;
                }
                case REQUIREMENTS_MANAGEMENT_TOOL: {
                    EIssueTracker eIssueTracker = connectorEnum = (ERequirementsManagementTool)EnumUtils.valueOfIgnoreCase(ERequirementsManagementTool.class, (String)connectorEnumName);
                }
            }
            if (connectorEnum == null) {
                throw new BadRequestException("Invalid connector enum value: " + connectorEnumName);
            }
            connectorTypeInfo = new ExternalCredentials.ConnectorTypeInfo(externalCredentialsData.connectorTypeInfo.connectorType, (IConnectorEnum)connectorEnum);
        }
        ExternalCredentials externalCredentials = new ExternalCredentials(externalCredentialsData.credentialsName, externalCredentialsData.uri.trim(), username, password, connectorTypeInfo);
        externalCredentials.setLastChangeInformation(this.getUser().getUsername(), System.currentTimeMillis());
        return externalCredentials;
    }

    private void deleteExternalAccounts(ExternalCredentialsData externalCredentials, boolean skipValidation) throws StorageException {
        if (!skipValidation) {
            this.validateNotUsedByAnyProjects(externalCredentials);
            this.validateNotUsedByAnyExternalStorageBackends(externalCredentials);
        }
        this.deleteElementAndPermissions(externalCredentials);
    }

    private void validateNotUsedByAnyProjects(ExternalCredentialsData externalCredentials) throws StorageException {
        ListMap<PublicProjectId, ConnectorConfiguration> affectedConnectorsByProject = this.getAffectedConnectorsByProject(externalCredentials.credentialsName);
        ListMap errorsByProject = new ListMap();
        for (PublicProjectId project : affectedConnectorsByProject.getKeys()) {
            errorsByProject.add((Object)project, (Object)"Credentials are used by this project.");
        }
        if (!errorsByProject.isEmpty()) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorsByProject.collectionsToArrays(String.class)).build());
        }
    }

    private void validateNotUsedByAnyExternalStorageBackends(ExternalCredentialsData externalCredentials) throws StorageException {
        ListMap errorsByExternalStorageBackend = new ListMap();
        for (ExternalStorageBackend backend : this.openGlobalIndex(ExternalStorageBackendIndex.class).getAllExternalStorageBackends()) {
            if (!backend.credentialsName().equals(externalCredentials.credentialsName)) continue;
            errorsByExternalStorageBackend.add((Object)backend.externalStorageBackendName(), (Object)"Credentials are used by this external storage backend.");
        }
        if (!errorsByExternalStorageBackend.isEmpty()) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorsByExternalStorageBackend.collectionsToArrays(String.class)).build());
        }
    }

    private void updateRepositoryToTriggerMappingIndex(ListMap<PublicProjectId, ConnectorConfiguration> connectors, ConfigurationInitializationContext context, String oldURI) throws StorageException, ProjectConfigurationException {
        for (Map.Entry connector : connectors) {
            PublicProjectId projectId = (PublicProjectId)connector.getKey();
            CommitResolvingStorageSystem projectStorageSystem = this.getIndexLayer().openProjectStorageSystem((IProjectId)projectId);
            ProjectCreationProxy proxy = this.getProjectCreationProxy((ProjectStorageSystem)projectStorageSystem);
            ArrayList<ConnectorDescriptorBase> connectorDescriptors = new ArrayList<ConnectorDescriptorBase>();
            try {
                for (ConnectorConfiguration conConfig : (List)connector.getValue()) {
                    ConnectorDescriptorBase connectorDescriptor = ConnectorUtils.loadConnector((ConnectorConfiguration)conConfig, (ConfigurationInitializationContext)context, (InternalProjectId)this.getIndexLayer().resolveToInternalProjectId((IProjectId)projectId));
                    connectorDescriptor.configureProject(proxy);
                    connectorDescriptors.add(connectorDescriptor);
                }
                for (ConnectorDescriptorBase connectorDescriptor : connectorDescriptors) {
                    connectorDescriptor.storeConfigurationData((ProjectStorageSystem)projectStorageSystem);
                    connectorDescriptor.deleteConfigurationData((ProjectStorageSystem)projectStorageSystem, oldURI);
                }
            }
            catch (ProjectConfigurationException e) {
                String message = "Could not update credentials in project " + String.valueOf(projectId);
                LOGGER.error(message, (Throwable)e);
                throw new StorageException(message, (Throwable)e);
            }
        }
    }

    private ProjectCreationProxy getProjectCreationProxy(ProjectStorageSystem projectStorageSystem) throws StorageException, ProjectConfigurationException {
        ProjectConfiguration oldProjectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)projectStorageSystem);
        List oldTriggers = ProjectConfigurationUtils.loadPreviousTriggers((GlobalStorageSystem)this.getGlobalStorageSystem(), (ProjectStorageSystem)projectStorageSystem);
        CodeScopeAware analysisProfiles = CodeScopeAware.empty();
        for (CodeScopeName codeScope : oldProjectConfiguration.getCodeScopeNames()) {
            AnalysisProfile profile = this.getAnalysisProfile(oldProjectConfiguration, codeScope);
            analysisProfiles.setValue(codeScope, (Object)profile);
        }
        InternalProjectId parentProjectId = null;
        if (oldProjectConfiguration.getParentProjectId() != null) {
            parentProjectId = this.getIndexLayer().resolveToInternalProjectId(oldProjectConfiguration.getParentProjectId());
        }
        CodeScopeAware configuredLanguages = analysisProfiles.map(AnalysisProfile::getLanguages);
        return new ProjectCreationProxy(oldProjectConfiguration.getInternalId(), oldProjectConfiguration.getExternalStorageProjectMappingId(), parentProjectId, configuredLanguages, oldProjectConfiguration, oldProjectConfiguration, oldTriggers, oldProjectConfiguration.getCodeScopes());
    }

    private AnalysisProfile getAnalysisProfile(ProjectConfiguration oldProjectConfiguration, CodeScopeName codeScopeName) throws ProjectConfigurationException, StorageException {
        AnalysisProfile profile = oldProjectConfiguration.getEmbeddedProfile(codeScopeName);
        if (profile == null) {
            LOGGER.warn("Changing external credentials on a project with no embedded analysis profile. Falling back to reference analysis profile instead.");
            profile = ProjectConfigurationUtils.determineAnalysisProfile((IndexLayer)this.getIndexLayer(), (ProjectConfiguration)oldProjectConfiguration, (CodeScopeName)codeScopeName);
        }
        return profile;
    }

    public static final class ExternalCredentialsData {
        private static final String CREDENTIALS_NAME_PROPERTY = "credentialsName";
        private static final String URI_PROPERTY = "uri";
        private static final String USERNAME_PROPERTY = "username";
        private static final String PASSWORD_PROPERTY = "password";
        private static final String CONNECTOR_TYPE_INFO_PROPERTY = "connectorTypeInfo";
        private static final String LAST_CHANGE_TIMESTAMP_PROPERTY = "lastChangeTimestamp";
        private static final String LAST_CHANGE_USER_PROPERTY = "lastChangeUserFullName";
        @JsonProperty(value="credentialsName")
        public final String credentialsName;
        @JsonProperty(value="uri")
        public final String uri;
        @JsonProperty(value="username")
        public final String username;
        @JsonProperty(value="password")
        public final String password;
        @JsonProperty(value="connectorTypeInfo")
        public final @Nullable ConnectorTypeInfoData connectorTypeInfo;
        @JsonProperty(value="lastChangeTimestamp")
        public final long lastChangeTimestamp;
        @JsonProperty(value="lastChangeUserFullName")
        public final @Nullable String lastChangeUserFullName;

        public ExternalCredentialsData(ExternalCredentials externalCredentials, Map<String, User> userNameToUser) {
            this.credentialsName = externalCredentials.credentialsName;
            this.uri = externalCredentials.uri;
            this.password = ExternalAccountsService.MASKED_PASSWORD;
            this.connectorTypeInfo = new ConnectorTypeInfoData(externalCredentials.connectorTypeInfo);
            this.username = externalCredentials.connectorTypeInfo.connectorEnum.getPasswordType() == EPasswordType.SECRET_KEY ? ExternalAccountsService.MASKED_PASSWORD : externalCredentials.username;
            this.lastChangeTimestamp = externalCredentials.getLastChangeTimestamp();
            User user = userNameToUser.get(externalCredentials.getLastChangeUser());
            this.lastChangeUserFullName = user != null ? user.getFullName() : externalCredentials.getLastChangeUser();
        }

        @JsonCreator
        public ExternalCredentialsData(@JsonProperty(value="credentialsName") String credentialsName, @JsonProperty(value="uri") String uri, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="connectorTypeInfo") @Nullable ConnectorTypeInfoData connectorTypeInfo, @JsonProperty(value="lastChangeTimestamp") long lastChangeTimestamp, @JsonProperty(value="lastChangeUserFullName") @Nullable String lastChangeUserFullName) {
            this.credentialsName = credentialsName;
            this.uri = uri;
            this.username = username;
            this.password = password;
            this.connectorTypeInfo = connectorTypeInfo;
            this.lastChangeTimestamp = lastChangeTimestamp;
            this.lastChangeUserFullName = lastChangeUserFullName;
        }
    }

    public static final class ConnectorTypeInfoData {
        private static final String CONNECTOR_TYPE_PROPERTY = "connectorType";
        private static final String CONNECTOR_ENUM_PROPERTY = "connectorEnum";
        @JsonProperty(value="connectorType")
        public final EConnectorType connectorType;
        @JsonProperty(value="connectorEnum")
        public final String connectorEnum;

        @JsonCreator
        public ConnectorTypeInfoData(@JsonProperty(value="connectorType") EConnectorType connectorType, @JsonProperty(value="connectorEnum") String connectorEnum) {
            this.connectorType = connectorType;
            this.connectorEnum = connectorEnum;
        }

        public ConnectorTypeInfoData(ExternalCredentials.ConnectorTypeInfo connectorTypeInfo) {
            this.connectorType = connectorTypeInfo.connectorType;
            this.connectorEnum = ((Enum)connectorTypeInfo.connectorEnum).name();
        }

        public ConnectorTypeInfoData() {
            this(new ExternalCredentials.ConnectorTypeInfo());
        }
    }
}

