/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin;

import com.teamscale.core.utils.VelocityEngineUtils;
import com.teamscale.service.base.ApiBase;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class ServerRenderedPageServiceBase
extends ApiBase {
    @Context
    protected ContainerRequestContext containerRequestContext;
    private Supplier<String> csrfTokenSupplier = () -> this.serviceInfo.getAuthenticationRequestHandler().getCsrfToken(this.containerRequestContext);

    @VisibleForTesting
    public void setCsrfTokenSupplier(Supplier<String> csrfTokenSupplier) {
        this.csrfTokenSupplier = csrfTokenSupplier;
    }

    public String buildHttpFormPage() {
        String templateName = this.getTemplatePathForCurrentClass();
        return this.buildHttpFormPageForTemplate(templateName, Collections.emptyMap());
    }

    private String getTemplatePathForCurrentClass() {
        return this.getClass().getName().replace(".", "/") + "Page.vm";
    }

    private String buildHttpFormPageForTemplate(String templatePath, Map<String, Object> templateParameters) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(templateParameters);
        parameterMap.put("csrfToken", this.csrfTokenSupplier.get());
        return VelocityEngineUtils.renderTemplate((String)templatePath, parameterMap);
    }
}

