/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.backup;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Optional;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

public class BackupImportParameters {
    @Parameter(description="The backups to import.")
    @ArraySchema(schema=@Schema(type="string", format="binary"))
    @FormDataParam(value="backup")
    private List<FormDataBodyPart> backup;
    @Parameter(description="Path to the backup")
    @FormDataParam(value="backup-path")
    private String backupPath;
    @Parameter(description="Whether to enable shadow mode right after import.")
    @FormDataParam(value="shadow-mode")
    private Boolean enableShadowMode;
    @Parameter(description="Whether to skip new projects and only import backup data into existing projects.")
    @FormDataParam(value="skip-new-projects")
    private Boolean skipNewProjects;
    @Parameter(description="Whether to skip the project validation on import")
    @FormDataParam(value="skip-project-validation")
    private Boolean skipProjectValidation;
    @Parameter(description="Whether to skip importing global data")
    @FormDataParam(value="skip-global-data-import")
    private Boolean skipGlobalDataImport;
    @Parameter(description="Path to the instance")
    @FormDataParam(value="remote-url")
    private String remoteUrl;
    @Parameter(description="Remote user")
    @FormDataParam(value="remote-user")
    private String remoteUser;
    @Parameter(description="Remote user access token")
    @FormDataParam(value="remote-access-token")
    private String accessToken;

    public List<FormDataBodyPart> getBackup() {
        return this.backup;
    }

    public void setBackup(List<FormDataBodyPart> backup) {
        this.backup = backup;
    }

    public String getBackupPath() {
        return this.backupPath;
    }

    public void setBackupPath(String backupPath) {
        this.backupPath = backupPath;
    }

    public boolean isEnableShadowMode() {
        return Optional.ofNullable(this.enableShadowMode).orElse(false);
    }

    public void setEnableShadowMode(boolean enableShadowMode) {
        this.enableShadowMode = enableShadowMode;
    }

    public boolean isSkipNewProjects() {
        return Optional.ofNullable(this.skipNewProjects).orElse(false);
    }

    public boolean isSkipProjectValidation() {
        return Optional.ofNullable(this.skipProjectValidation).orElse(false);
    }

    public void setSkipProjectValidation(boolean skipProjectValidation) {
        this.skipProjectValidation = skipProjectValidation;
    }

    public boolean isSkipGlobalDataImport() {
        return Optional.ofNullable(this.skipGlobalDataImport).orElse(false);
    }

    public void setSkipGlobalDataImport(boolean skipGlobalDataImport) {
        this.skipGlobalDataImport = skipGlobalDataImport;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }
}

