/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.profiler;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.service.admin.profiler.RunningProfilerInfoDTO;
import com.teamscale.service.base.SortAndPaginationOptions;
import jakarta.ws.rs.BadRequestException;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public record RunningProfilersResult(@JsonProperty(value="resultSize") int resultSize, @JsonProperty(value="runningProfilers") List<RunningProfilerInfoDTO> runningProfilers) {
    public static RunningProfilersResult from(List<RunningProfilerInfoDTO> runningProfilers, SortAndPaginationOptions sortAndPaginationOptions) {
        Function comparatorProvider = RunningProfilersResult::getComparatorForField;
        return new RunningProfilersResult(runningProfilers.size(), sortAndPaginationOptions.sortAndPaginate(runningProfilers, comparatorProvider));
    }

    private static Comparator<RunningProfilerInfoDTO> getComparatorForField(String sortBy) {
        return switch (sortBy) {
            case "hostname" -> Comparator.comparing(profiler -> profiler.processInformation().hostname());
            case "pid" -> Comparator.comparing(profiler -> profiler.processInformation().pid());
            case "configurationId" -> Comparator.comparing(RunningProfilerInfoDTO::configurationId);
            case "startedAtTimestamp" -> Comparator.comparing(profiler -> profiler.processInformation().startedAtTimestamp());
            case "lastHeartbeatTimestamp" -> Comparator.comparing(RunningProfilerInfoDTO::lastHeartbeatTimestamp);
            case "status" -> Comparator.comparing(RunningProfilerInfoDTO::status);
            case "health" -> Comparator.nullsLast(Comparator.comparing(RunningProfilerInfoDTO::health));
            default -> throw new BadRequestException("Invalid sort-by value " + sortBy);
        };
    }
}

