/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.teamscale.index.architecture.ArchitectureAssessmentIndex;
import com.teamscale.index.architecture.ArchitectureAssessmentInfo;
import com.teamscale.index.architecture.ArchitectureAssessmentInfoUtils;
import com.teamscale.index.architecture.ArchitectureComponentInfo;
import com.teamscale.index.architecture.commons.EFindingCreationType;
import com.teamscale.index.architecture.commons.EStereotype;
import com.teamscale.index.architecture.external.ArchitectureUploadAnalysisStateIndex;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

final class ArchitectureAssessmentUtils {
    protected static final ArchitectureAssessmentInfo EMPTY_ASSESSMENT = ArchitectureAssessmentInfo.builder().withRoot(ArchitectureComponentInfo.builder().withName("").withPosition(new Point(0, 0)).withDimension(new Dimension(0, 0)).withStereotype(EStereotype.NONE).build()).withFileBased(true).withFindingCreation(EFindingCreationType.UNSELECTED).build();
    private static final String ARCHITECTURE_VIOLATION_FINDING_TYPEID = "Architecture Conformance/Architecture violation";

    public static ArchitectureAssessmentInfo getAssessmentInfo(String uniformPath, ArchitectureAssessmentIndex architectureAssessmentIndex) throws StorageException {
        ArchitectureAssessmentInfo architectureAssessment = architectureAssessmentIndex.getAssessment(uniformPath);
        if (architectureAssessment == null) {
            return EMPTY_ASSESSMENT;
        }
        return architectureAssessment;
    }

    public static ArchitectureDefinition getArchitectureDefinition(String uniformPath, TokenElementIndex contentIndex) throws StorageException {
        TokenElementInfo element = contentIndex.getTokenElement(uniformPath);
        if (element == null) {
            return null;
        }
        return ArchitectureAssessmentInfoUtils.getArchitectureDefinition((TokenElementInfo)element, (String)uniformPath);
    }

    public static Map<String, ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType> getUploadsInProgress(ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyOption) throws StorageException {
        ArchitectureUploadAnalysisStateIndex analysisStateIndex = (ArchitectureUploadAnalysisStateIndex)projectStorageSystem.openProjectIndex(ArchitectureUploadAnalysisStateIndex.class, null);
        PairList analysisStateEntries = analysisStateIndex.getAllUploadsForBranch(historyOption.getBranchName());
        HashMap<String, CommitDescriptor> newestKeys = new HashMap<String, CommitDescriptor>();
        HashMap<String, ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType> returnMap = new HashMap<String, ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType>();
        for (Pair entry : analysisStateEntries) {
            Pair key = ArchitectureUploadAnalysisStateIndex.splitKey((String)((String)entry.getFirst()));
            if (newestKeys.containsKey(key.getFirst()) && ((CommitDescriptor)newestKeys.get(key.getFirst())).getTimestamp() >= ((CommitDescriptor)key.getSecond()).getTimestamp()) continue;
            newestKeys.put((String)key.getFirst(), (CommitDescriptor)key.getSecond());
            returnMap.put((String)key.getFirst(), (ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType)entry.getSecond());
        }
        return returnMap;
    }

    public static ListMap<Pair<String, String>, String> getViolationFindingsForArchitecture(ArchitectureDefinition architecture, Map<UniformPath, List<TrackedFinding>> findingsByPath) {
        String architectureUniformPath = architecture.getName();
        List<TrackedFinding> findings = findingsByPath.values().stream().flatMap(Collection::stream).filter(finding -> finding.getTypeId().equals(ARCHITECTURE_VIOLATION_FINDING_TYPEID) && finding.getFindingIndexPartition().equals(architectureUniformPath)).toList();
        ListMap architectureFindingsMap = new ListMap();
        for (TrackedFinding finding2 : findings) {
            Object target = finding2.getProperties().get("architecture-dependency-violation-target");
            Object source = finding2.getProperties().get("architecture-dependency-violation-source");
            if (target == null || source == null) continue;
            architectureFindingsMap.add((Object)new Pair((Object)String.valueOf(source), (Object)String.valueOf(target)), (Object)finding2.getId());
        }
        return architectureFindingsMap;
    }

    private ArchitectureAssessmentUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

