/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.architecture.ArchitectureConverter;
import com.teamscale.service.architecture.ArchitectureUploadService;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.upload.base.ExternalUploadServiceQueryOptions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;

public interface IArchitectureUploadServiceApi {
    @POST
    @Path(value="as-json")
    @Operation(summary="Upload architecture", description="Saves an architecture definition.", tags={"Architecture"}, responses={@ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="400", description="One of the components contains an invalid regular expression pattern"), @ApiResponse(responseCode="404", description="Revision provided in the query parameter could not be found.")})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_ARCHITECTURES})
    public void uploadArchitectureAsJson(@BeanParam ExternalUploadServiceQueryOptions var1, @Parameter(description="The commit message describing the changes made by the upload.") @QueryParam(value="message") @DefaultValue(value="Imported new architecture") String var2, @RequestBody(required=true) ArchitectureUploadService.ArchitectureInfoWithUniformPath var3, @Parameter(description="If true, the architecture will be saved to all important branches and default branch in addition to the current branch") @QueryParam(value="save-to-all-important-branches") @DefaultValue(value="false") boolean var4) throws ConQATException;

    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Operation(summary="Upload architecture", description="Imports an architecture file.", tags={"Architecture"}, responses={@ApiResponse(responseCode="400", description="No path for architecture given. \t\nArchitecture path must have extension.architecture. \t\nUpload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="404", description="Revision provided in the query parameter could not be found.")})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_ARCHITECTURES})
    @Consumes(value={"multipart/form-data"})
    public void uploadArchitecture(@BeanParam ExternalUploadServiceQueryOptions var1, @Parameter(description="The commit message describing the changes made by the upload.") @QueryParam(value="message") @DefaultValue(value="Imported new architecture") String var2, @Parameter(description="The parameter that determines the upload format.") @QueryParam(value="format") @DefaultValue(value="TEAMSCALE_ARCHITECTURE") ArchitectureConverter.EArchitectureFormat var3, @Parameter(description="The parameter used for passing in a template architecture.") @QueryParam(value="template") String var4, @RequestBody(content={@Content(mediaType="multipart/form-data", schema=@Schema(type="object"), additionalPropertiesSchema=@Schema(type="string", format="binary"))}) FormDataMultiPart var5, @Parameter(description="If true, the architecture will be saved to all important branches and default branch in addition to the current branch") @QueryParam(value="save-to-all-important-branches") @DefaultValue(value="false") boolean var6) throws StorageException, BadRequestException;

    @DELETE
    @Path(value="{uniformPath}/all-commits")
    @RequiresProjectPermission(value={EProjectPermission.EDIT_ARCHITECTURES})
    @Operation(summary="Delete all architecture commits", description="Deletes all commits of the architecture identified by the provided architecture path.", tags={"Architecture"})
    public void deleteAllArchitectureCommits(@Parameter(description="The uniform path of the architecture to be deleted") @PathParam(value="uniformPath") UniformPath var1, @Parameter(description="The commit message describing the changes made by the upload.") @QueryParam(value="message") @DefaultValue(value="Imported new architecture") String var2) throws StorageException;

    @DELETE
    @Path(value="{uniformPath}")
    @RequiresProjectPermission(value={EProjectPermission.EDIT_ARCHITECTURES})
    @Operation(summary="Delete architecture", description="Deletes the architecture identified by the provided architecture path.", tags={"Architecture"}, responses={@ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time. \t\nCan't perform architecture delete for project with no architecture commit."), @ApiResponse(responseCode="404", description="Revision provided in the query parameter could not be found.")})
    public void deleteArchitecture(@BeanParam ExternalUploadServiceQueryOptions var1, @Parameter(description="The uniform path of the deleted architecture") @PathParam(value="uniformPath") UniformPath var2, @Parameter(description="The commit message describing the changes made by the upload.") @QueryParam(value="message") @DefaultValue(value="Imported new architecture") String var3) throws StorageException;
}

