/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.audit.CodeComponentsTreeMapBuilder;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.metrics.treemap.FilteredTreeMapWrapper;
import com.teamscale.service.metrics.treemap.TreemapQueryOptions;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/audit/code-components-treemap/")
public class CodeComponentsTreeMapService
extends ApiBase {
    private static final String PARAM_NAME_HIGHLIGHT_COLOR = "highlight-color";
    private static final String PARAM_NAME_HIGHLIGHT_TERM = "highlight-term";
    private static final String PARAM_DESCRIPTION_HIGHLIGHT_COLOR = "Color (as 6-digit hex value without preceding #) for highlighted components.";
    private static final String PARAM_DESCRIPTION_HIGHLIGHT_TERM = "Pattern to color only matching components.";
    private static final String PARAM_NAME_IS_SHOW_COMPONENTS = "is-show-components";
    private static final String PARAM_DESCRIPTION_IS_SHOW_COMPONENTS = "Specifies whether top-level components should be colored or whether languages should be colored";

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get a treemap that colors components or languages", description="Either top-level components or the used languages can be colored.", tags={"Audit"})
    public FilteredTreeMapWrapper getCodeComponentsTreemapWrapper(@Parameter(required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit, @BeanParam TreemapQueryOptions treemapRequestOptions, @QueryParam(value="highlight-color") @Parameter(description="Color (as 6-digit hex value without preceding #) for highlighted components.") String highlightColor, @QueryParam(value="highlight-term") @Parameter(description="Pattern to color only matching components.") Pattern highlightPattern, @QueryParam(value="is-show-components") @Parameter(description="Specifies whether top-level components should be colored or whether languages should be colored") boolean isShowComponents) throws StorageException, TreeMapBuilderException {
        treemapRequestOptions.postProcess(MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser()).getMetricDirectorySchema(), false);
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        EVisualizationContent visualizationContent = EVisualizationContent.TOP_LEVEL_COMPONENTS;
        if (!isShowComponents) {
            visualizationContent = EVisualizationContent.LANGUAGES;
        }
        return this.createAndRunTreeMapBuilder(uniformPath, historyAccessOption, treemapRequestOptions, highlightColor, highlightPattern, visualizationContent);
    }

    private FilteredTreeMapWrapper createAndRunTreeMapBuilder(UniformPath uniformPath, HistoryAccessOption historyAccessOption, TreemapQueryOptions treemapRequestOptions, String highlightColor, Pattern highlightPattern, EVisualizationContent visualizationContent) throws StorageException, TreeMapBuilderException {
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser());
        CodeComponentsTreeMapBuilder treeMapBuilder = new CodeComponentsTreeMapBuilder(metricRetrievalStrategy, historyAccessOption, uniformPath, treemapRequestOptions, highlightColor, highlightPattern, visualizationContent);
        FilteredTreeMapWrapper result = treeMapBuilder.getWrapper(uniformPath);
        result.setColorHashByLegendText(treeMapBuilder.getColorHashByLegendText());
        return result;
    }

    public static enum EVisualizationContent {
        TOP_LEVEL_COMPONENTS,
        LANGUAGES;

    }
}

