/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.index.dependencies.DependencyListIndex;
import com.teamscale.index.resource.TokenElementIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ThirdPartyDependencyExtractor {
    private String dependencySearchString;
    private DependencyListIndex dependencyIndex;
    private int maxPackageDepth;
    private Set<String> contentIndexKeys;

    public ThirdPartyDependencyExtractor(ProjectStorageSystem storageSystem, HistoryAccessOption historyAccessOption, String dependencySearchString, int maxPackageDepth) throws StorageException {
        this.dependencyIndex = (DependencyListIndex)storageSystem.openProjectIndex(DependencyListIndex.class, "dependencies", historyAccessOption);
        TokenElementIndex contentIndex = (TokenElementIndex)storageSystem.openProjectIndex(TokenElementIndex.class, "content", historyAccessOption);
        this.contentIndexKeys = new HashSet<String>(contentIndex.getAllUniformPaths());
        this.dependencySearchString = dependencySearchString;
        this.maxPackageDepth = maxPackageDepth;
    }

    public Set<String> retrieveAllDependencies() throws StorageException {
        HashSet<String> allDependencies = new HashSet<String>();
        for (ArrayList dependencyList : this.dependencyIndex.getAllDependencies().extractSecondList()) {
            allDependencies.addAll(dependencyList);
        }
        return new HashSet<String>(this.cropPackageDepth(this.filter(this.get3rdPartyDependencies(allDependencies))));
    }

    public Set<String> retrieveDependencies(String uniformPath) throws StorageException {
        List fileDependencies = this.dependencyIndex.getDependencies(uniformPath);
        if (fileDependencies == null) {
            return new HashSet<String>();
        }
        return this.cropPackageDepth(this.filter(this.get3rdPartyDependencies(fileDependencies)));
    }

    private Set<String> cropPackageDepth(Set<String> dependencies) {
        if (this.maxPackageDepth == -1) {
            return dependencies;
        }
        HashSet<String> result = new HashSet<String>();
        if (this.maxPackageDepth == 0) {
            return result;
        }
        return new HashSet<String>(CollectionUtils.map(dependencies, dependency -> this.cropPackageDepth((String)dependency)));
    }

    private String cropPackageDepth(String dependency) {
        int position = StringUtils.ordinalIndexOf((CharSequence)dependency, (CharSequence)".", (int)this.maxPackageDepth);
        if (position == -1) {
            return dependency;
        }
        return dependency.substring(0, position);
    }

    private Set<String> filter(Set<String> dependencies) {
        if (this.dependencySearchString == null) {
            return dependencies;
        }
        return CollectionUtils.filterToSet(dependencies, d -> d.startsWith(this.dependencySearchString));
    }

    private Set<String> get3rdPartyDependencies(Collection<String> dependencies) {
        return CollectionUtils.differenceSet(dependencies, (Collection[])new Collection[]{this.contentIndexKeys});
    }
}

