/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.benchmark;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.service.audit.benchmark.BenchmarkMetaDataOption;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.jspecify.annotations.Nullable;

@Path(value="api/benchmark-projects")
public class BenchmarkProjectsService
extends ApiBase {
    @GET
    @Operation(summary="Get benchmark projects", description="Returns the projects with benchmark analysis profiles")
    @RequiresComplexPermission(value=EComplexPermission.MAY_ACCESS_AUDIT_PERSPECTIVE)
    public List<ProjectDescription> getBenchmarkProjects() throws StorageException {
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        ArrayList<ProjectDescription> projectDescriptions = new ArrayList<ProjectDescription>();
        for (ProjectInfo projectInfo : projectIndex.getAllProjectInfos()) {
            Optional<ProjectDescription> projectDescription = this.getProjectDescription(projectInfo);
            if (projectDescription.isEmpty()) continue;
            CommitResolvingStorageSystem projectStorageSystem = this.getProjectStorageSystem(projectInfo);
            ProjectOptionIndex projectOptionIndex = (ProjectOptionIndex)projectStorageSystem.openProjectIndex(ProjectOptionIndex.class, null);
            Optional<BenchmarkMetaDataOption> benchmarkMetaData = BenchmarkMetaDataOption.getBenchmarkMetaData(projectOptionIndex);
            benchmarkMetaData.ifPresent(projectDescription.get()::addMetaData);
            projectDescriptions.add(projectDescription.get());
        }
        return projectDescriptions;
    }

    private Optional<ProjectDescription> getProjectDescription(ProjectInfo projectInfo) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.getIndexLayer().openProjectStorageSystem((IProjectId)projectInfo.getPrimaryPublicId());
        Set configuredLanguages = AnalysisProfileUtils.getConfiguredLanguages((Collection)AnalysisProfileUtils.getEmbeddedAnalysisProfiles((ProjectStorageSystem)projectStorageSystem));
        if (configuredLanguages.size() != 1) {
            return Optional.empty();
        }
        Pair<Long, String> latestTimestampAndRevision = this.getLatestTimestampAndRevision(projectInfo);
        return Optional.of(new ProjectDescription(projectInfo.getPrimaryPublicId(), projectInfo.getName(), (Long)latestTimestampAndRevision.getFirst(), (String)latestTimestampAndRevision.getSecond(), (ELanguage)CollectionUtils.getAny((Iterable)configuredLanguages)));
    }

    private Pair<Long, String> getLatestTimestampAndRevision(ProjectInfo projectInfo) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.getProjectStorageSystem(projectInfo);
        RepositoryLogIndex repositoryLogIndex = (RepositoryLogIndex)projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null);
        String defaultBranch = ((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null)).getDefaultBranchName();
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        Optional latestCommit = commitDescriptorIndex.getLatestCommitForBranch(defaultBranch);
        if (latestCommit.isPresent()) {
            return Pair.createPair((Object)((ParentedCommitDescriptor)latestCommit.get()).getTimestamp(), (Object)Objects.requireNonNull((RepositoryLogEntryAggregate)repositoryLogIndex.getEntry((CommitDescriptor)latestCommit.get())).getRevision());
        }
        RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)repositoryLogIndex.getEntry(CommitDescriptor.latestOnBranch((String)defaultBranch));
        String revision = "unknown";
        long timestamp = 0L;
        if (logEntry != null) {
            revision = logEntry.getRevision();
            timestamp = CommitDescriptor.latestOnBranch((String)defaultBranch).getTimestamp();
        }
        return Pair.createPair((Object)timestamp, (Object)revision);
    }

    private static class ProjectDescription {
        @JsonProperty(value="projectId")
        private final PublicProjectId projectId;
        @JsonProperty(value="projectName")
        private final String projectName;
        @JsonProperty(value="language")
        private final ELanguage language;
        @JsonProperty(value="anonym")
        private final boolean anonym;
        @JsonProperty(value="company")
        private @Nullable String company;
        @JsonProperty(value="revision")
        private String revision;
        @JsonProperty(value="date")
        private Date date;
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="isOpenSource")
        private boolean isOpenSource;
        @JsonProperty(value="isQualityControlled")
        private boolean isQualityControlled;

        private ProjectDescription(PublicProjectId projectId, String projectName, long timestamp, String revision, ELanguage language) {
            this.projectId = projectId;
            this.projectName = projectName;
            this.date = Date.from(DateTimeUtils.atZone((long)timestamp).toInstant());
            this.revision = revision;
            this.language = language;
            this.anonym = false;
        }

        private void addMetaData(BenchmarkMetaDataOption benchmarkMetaData) {
            this.company = benchmarkMetaData.organization;
            this.domain = benchmarkMetaData.domain;
            this.isOpenSource = benchmarkMetaData.openSource;
            this.isQualityControlled = benchmarkMetaData.qualityControlled;
        }
    }
}

