/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.benchmark;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.FindingsSummaryCalculator;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.FindingsSummaryCategoryInfo;
import org.conqat.engine.index.shared.FindingsSummaryGroupInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/audit/benchmark")
public class ProjectBenchmarkDownloadService
extends ApiBase {
    private static final PairList<String, String> BASIC_METRICS = new PairList();
    private static final Pattern ANALYSIS_PROFILE_NAME_PREFIX = Pattern.compile("^.*-");
    private static final List<String> ADVANCED_METRIC_UI_NAME;
    private static final List<String> CATEGORY_NAMES;

    @GET
    @Operation(summary="Download the benchmark results", description="Downloads the benchmark results for a project", tags={"Audit"}, responses={@ApiResponse(responseCode="400", description="Could not determine project config for project. Could not download benchmark result for a project that does not use a benchmark analysis profile. Could not download benchmark result for a project whose analysis profile has an invalid name. Analysis profile used by project has more than one language. Analysis profile used by project has different language than suggested by its name."), @ApiResponse(responseCode="404", description="Analysis profile used by the project was not found in the index, or no metrics available for the project.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public Response downloadBenchmark(@Parameter(description="Uniform path to download a benchmark for", allowEmptyValue=true, required=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        MetricDirectoryIndex metricDirectoryIndex = this.openProjectIndex(MetricDirectoryIndex.class, "metrics-dir", historyOption);
        MetricSchemaIndex metricSchemaIndex = this.openProjectIndex(MetricSchemaIndex.class, "metric-schema", historyOption.cloneToUnbranchedAccessOption());
        TrackedFindingsIndex findingsIndex = this.openProjectIndex(TrackedFindingsIndex.class, historyOption);
        MetaIndex metaIndex = this.openProjectIndex(MetaIndex.class, null);
        AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        RepositoryLogIndex logIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
        BenchmarkResult benchmarkResult = ProjectBenchmarkDownloadService.getBenchmarkResult(this.serviceInfo.getPrimaryPublicId(), uniformPath, historyOption, metricDirectoryIndex, metricSchemaIndex, findingsIndex, logIndex, metaIndex, analysisProfileIndex, this.serviceInfo);
        String fileName = this.serviceInfo.getPrimaryPublicId().toString() + String.valueOf(ETeamscaleVersion.CURRENT_VERSION) + ".json";
        return ResponseUtils.getFileDownloadResponse((Object)benchmarkResult, (MediaType)MediaType.APPLICATION_JSON_TYPE, (String)fileName);
    }

    private static BenchmarkResult getBenchmarkResult(PublicProjectId projectId, UniformPath uniformPath, HistoryAccessOption historyOption, MetricDirectoryIndex metricDirectoryIndex, MetricSchemaIndex metricSchemaIndex, TrackedFindingsIndex findingsIndex, RepositoryLogIndex logIndex, MetaIndex metaIndex, AnalysisProfileIndex analysisProfileIndex, ITeamscaleServiceInfo serviceInfo) throws StorageException {
        ELanguage language = ProjectBenchmarkDownloadService.determineLanguage(metaIndex, analysisProfileIndex, projectId);
        long timestamp = historyOption.getTimestamp();
        if (historyOption.isReadHead()) {
            timestamp = logIndex.getNewestTimestamp();
        }
        BenchmarkResult benchmarkResult = new BenchmarkResult(projectId, uniformPath, timestamp, ETeamscaleVersion.CURRENT_VERSION, language);
        ProjectBenchmarkDownloadService.addBasicBenchmarkMetrics(metricDirectoryIndex, uniformPath, metricSchemaIndex, benchmarkResult, language);
        ProjectBenchmarkDownloadService.addAdvancedBenchmarkMetrics(findingsIndex, uniformPath, benchmarkResult, language, serviceInfo);
        return benchmarkResult;
    }

    private static ELanguage determineLanguage(MetaIndex metaIndex, AnalysisProfileIndex analysisProfileIndex, PublicProjectId project) throws StorageException {
        ProjectConfiguration configuration = (ProjectConfiguration)metaIndex.getValue(ProjectConfiguration.class);
        if (configuration == null) {
            throw new BadRequestException("Could not determine project config for project " + String.valueOf(project));
        }
        String analysisProfileName = configuration.getAnalysisProfileName(CodeScopeAware.DEFAULT_CODE_SCOPE);
        if (!Objects.requireNonNull(analysisProfileName).toLowerCase().contains("benchmark")) {
            throw new BadRequestException("Error: Cannot download benchmark result for a project that does not use a benchmark analysis profile.");
        }
        ELanguage languageFromName = null;
        if (analysisProfileName.contains("-")) {
            languageFromName = (ELanguage)EnumUtils.valueOfIgnoreCase(ELanguage.class, (String)StringUtils.replaceAll((String)analysisProfileName, (Pattern)ANALYSIS_PROFILE_NAME_PREFIX, (String)""));
        }
        if (languageFromName == null) {
            throw new BadRequestException("Error: Cannot download benchmark result for a project whose analysis profile has an invalid name. Must end with valid language.");
        }
        ProjectBenchmarkDownloadService.checkLanguageFromNameVsProfile(project, analysisProfileName, languageFromName, analysisProfileIndex);
        return languageFromName;
    }

    private static void checkLanguageFromNameVsProfile(PublicProjectId project, String analysisProfileName, ELanguage languageFromName, AnalysisProfileIndex analysisProfileIndex) throws StorageException {
        AnalysisProfile analysisProfile = analysisProfileIndex.getProfile(analysisProfileName);
        if (analysisProfile == null) {
            throw new NotFoundException("Analysis profile " + analysisProfileName + " used by " + String.valueOf(project) + " was not found in the index.");
        }
        if (analysisProfile.getLanguages().size() != 1) {
            throw new BadRequestException("Analysis profile " + analysisProfileName + " used by " + String.valueOf(project) + " has more than one language, which is not supported!");
        }
        if (CollectionUtils.getAny((Iterable)analysisProfile.getLanguages()) != languageFromName) {
            throw new BadRequestException("Analysis profile " + analysisProfileName + " used by " + String.valueOf(project) + " has different language than suggested by its name!");
        }
    }

    private static void addBasicBenchmarkMetrics(MetricDirectoryIndex metricDirectoryIndex, UniformPath uniformPath, MetricSchemaIndex metricSchemaIndex, BenchmarkResult benchmarkResult, ELanguage language) throws StorageException {
        MetricDirectoryEntry metrics = metricDirectoryIndex.getMetricDirectoryEntry(uniformPath.toStringAsMigrationFrontier());
        if (metrics == null) {
            throw new NotFoundException("No metrics available for project");
        }
        MetricDirectorySchema schema = metricSchemaIndex.getPublicSchema();
        for (int i = 0; i < BASIC_METRICS.size(); ++i) {
            String analysis = (String)BASIC_METRICS.getSecond(i);
            if (!ProjectBenchmarkDownloadService.analysisExistsForLanguage(analysis, language)) continue;
            Object metricValue = metrics.getValue(schema.getValuePosition(analysis));
            benchmarkResult.addMetricValue((String)BASIC_METRICS.getFirst(i), metricValue);
        }
    }

    private static void addAdvancedBenchmarkMetrics(TrackedFindingsIndex findingsIndex, UniformPath uniformPath, BenchmarkResult benchmarkResult, ELanguage language, ITeamscaleServiceInfo serviceInfo) throws StorageException {
        List<TrackedFinding> findings = ProjectBenchmarkDownloadService.getFindings(findingsIndex, uniformPath);
        FindingsCalculationInfo calculationInfo = new FindingsCalculationInfo(serviceInfo.getPrimaryPublicId(), (ProjectStorageSystem)serviceInfo.getProjectStorageSystem(), serviceInfo.getIndexLayer());
        List findingsSummary = FindingsSummaryCalculator.createFindingsSummary(findings, (boolean)false, (boolean)false, (FindingsCalculationInfo)calculationInfo).getCategoryInfos();
        HashMap<String, Integer> findingCountByGroup = new HashMap<String, Integer>();
        for (FindingsSummaryCategoryInfo categoryInfo : findingsSummary) {
            for (FindingsSummaryGroupInfo groupInfo : categoryInfo.getGroupInfos()) {
                findingCountByGroup.put(groupInfo.getGroup(), groupInfo.getCount());
            }
        }
        for (int i = 0; i < CATEGORY_NAMES.size(); ++i) {
            if (!ProjectBenchmarkDownloadService.analysisExistsForLanguage(CATEGORY_NAMES.get(i), language)) continue;
            Object metricValue = findingCountByGroup.get(CATEGORY_NAMES.get(i));
            benchmarkResult.addMetricValue(ADVANCED_METRIC_UI_NAME.get(i), Objects.requireNonNullElse(metricValue, 0));
        }
    }

    private static List<TrackedFinding> getFindings(TrackedFindingsIndex findingsIndex, UniformPath uniformPath) throws StorageException {
        Map findingsByPath = findingsIndex.getFindingsWithKeyPrefix(uniformPath);
        return findingsByPath.values().stream().flatMap(Collection::stream).toList();
    }

    private static boolean analysisExistsForLanguage(String analysis, ELanguage language) {
        if (analysis.equals("Comment Completeness Assessment") || analysis.equals("Comment Completeness")) {
            return switch (language) {
                case ELanguage.JAVA, ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C -> true;
                default -> false;
            };
        }
        return true;
    }

    static {
        BASIC_METRICS.add((Object)"System Size (SLOC)", (Object)"Source Lines of Code");
        BASIC_METRICS.add((Object)"Clone Coverage (Length 10)", (Object)"Clone Coverage");
        BASIC_METRICS.add((Object)"File Size Assessment (SLOC)", (Object)"File Size Assessment");
        BASIC_METRICS.add((Object)"Method Length Assessment (SLOC, MBA)", (Object)"Method Length Assessment");
        BASIC_METRICS.add((Object)"Nesting Depth Assessment (SLOC, MBA)", (Object)"Nesting Depth Assessment");
        BASIC_METRICS.add((Object)"Comment Completeness Assessment", (Object)"Comment Completeness Assessment");
        ADVANCED_METRIC_UI_NAME = Arrays.asList("Clone Instance Count", "Long File Count", "Long Method Count", "Deep Nesting Count", "Missing Comment Count");
        CATEGORY_NAMES = Arrays.asList("Code Clones", "File Size", "Method Length", "Nesting Depth", "Comment Completeness");
    }

    public static class BenchmarkResult {
        @JsonProperty(value="project")
        private final PublicProjectId project;
        @JsonProperty(value="uniformPath")
        private final UniformPath uniformPath;
        @JsonProperty(value="timestamp")
        private final long timestamp;
        @JsonProperty(value="teamscaleVersion")
        private final ETeamscaleVersion teamscaleVersion;
        @JsonProperty(value="language")
        private final ELanguage language;
        @JsonProperty(value="doubleMetricValues")
        private final Map<String, Double> doubleMetricValues = new HashMap<String, Double>();
        @JsonProperty(value="assessmentMetricValues")
        private final Map<String, Assessment> assessmentMetricValues = new HashMap<String, Assessment>();

        public BenchmarkResult(PublicProjectId project, UniformPath uniformPath, long timestamp, ETeamscaleVersion teamscaleVersion, ELanguage language) {
            this.project = project;
            this.uniformPath = uniformPath.resolveToCodePath();
            this.timestamp = timestamp;
            this.teamscaleVersion = teamscaleVersion;
            this.language = language;
        }

        public PublicProjectId getProject() {
            return this.project;
        }

        public Map<String, Double> getDoubleMetricValues() {
            return this.doubleMetricValues;
        }

        public Map<String, Assessment> getAssessmentMetricValues() {
            return this.assessmentMetricValues;
        }

        public void addMetricValue(String metricName, Object metricValue) {
            if (metricValue instanceof Number) {
                this.doubleMetricValues.put(metricName, ((Number)metricValue).doubleValue());
            } else if (metricValue instanceof Assessment) {
                this.assessmentMetricValues.put(metricName, BenchmarkResult.normalize((Assessment)metricValue));
            } else {
                throw new InternalServerErrorException("Could not create a benchmark result for a metric value that is neither number nor assessment for metric: " + metricName);
            }
        }

        private static Assessment normalize(Assessment assessment) {
            Map<ETrafficLightColor, Integer> relativeValuesPerColor = EnumSet.allOf(ETrafficLightColor.class).stream().collect(Collectors.toMap(color -> color, color -> assessment.getColorFrequency(color) * 100 / assessment.getSize()));
            int sum = relativeValuesPerColor.values().stream().mapToInt(Integer::intValue).sum();
            if (sum != 100) {
                ETrafficLightColor mostFrequentColor = assessment.getMostFrequentColor();
                relativeValuesPerColor.put(mostFrequentColor, relativeValuesPerColor.get(mostFrequentColor) + (100 - sum));
            }
            Assessment relativeAssessment = new Assessment();
            relativeValuesPerColor.forEach((arg_0, arg_1) -> ((Assessment)relativeAssessment).add(arg_0, arg_1));
            return relativeAssessment;
        }
    }
}

