/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.file_summary;

import com.teamscale.service.audit.file_summary.FileSummary;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/file-summary")
public class FileSummaryService
extends ApiBase {
    @GET
    @RequiresComplexPermission(value=EComplexPermission.MAY_ACCESS_AUDIT_PERSPECTIVE)
    @Operation(summary="Get file summary", description="Retrieves the file summary showing the different file types in a given folder on the local file system along with the corresponding number of lines of code.", tags={"Audit"})
    public PairList<String, FileSummary.FileSummaryInfoRecord> getFileSummary(@Parameter(description="The path to a folder in the local file system for which the summary is created.") @QueryParam(value="path") String path, @Parameter(description="Included files of summary, given as ant pattern. Matching is case insensitive.") @QueryParam(value="includes") List<String> includes, @Parameter(description="Excluded files of summary, given as ant pattern. Matching is case insensitive.") @QueryParam(value="excludes") List<String> excludes) throws IOException {
        if (StringUtils.isEmpty((String)path)) {
            return new PairList();
        }
        FileSummary fileSummary = new FileSummary(path, FileSummaryService.removeSpaces(includes), FileSummaryService.removeSpaces(excludes));
        return fileSummary.getLinesOfCodeAndNumberOfFiles();
    }

    private static List<String> removeSpaces(List<String> strings) {
        return CollectionUtils.filterAndMap(strings, s -> !StringUtils.isEmpty((String)s), String::trim);
    }
}

