/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate.saml;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.authenticate.SsoAuthenticationServiceBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.Objects;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/auth/saml/idp-metadata")
public class SamlIdentityProviderMetadataService
extends SsoAuthenticationServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Returns the SAML metadata from the given URL.", description="This is meant to simplify SAML configuration in Teamscale.")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String getSamlIdentityProviderMetadata(@QueryParam(value="idp-url") String idpUrl) throws IOException {
        Request request = new Request.Builder().url(idpUrl).build();
        try (Response response = new OkHttpClient().newCall(request).execute();){
            String responseBody = Objects.requireNonNull(response.body(), "response body should never be null").string();
            if (response.isSuccessful()) {
                String string = responseBody;
                return string;
            }
            LOGGER.error("HTTP Error code " + response.code() + " when retrieving metadata from '" + idpUrl + "'. Response starts with:\n" + StringUtils.truncateWithEllipsis((String)responseBody, (int)1024));
            throw new InternalServerErrorException(response.message());
        }
    }
}

