/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.base;

import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import jakarta.ws.rs.BadRequestException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.factory.IFactory;

public record TimeRange(CommitDescriptor start, CommitDescriptor end) {
    public static TimeRange resolveTimeRange(UnresolvedCommitDescriptor start, UnresolvedCommitDescriptor end, long maxMillis, IFactory<ProjectStorageSystem, StorageException> projectStorageSystemFactory) throws StorageException {
        CommitDescriptor startCommit;
        CommitDescriptor endCommit;
        if (start == null) {
            if (maxMillis < 0L) {
                throw new BadRequestException("Either t1 or max-milliseconds must be given.");
            }
            if (end == null) {
                end = new UnresolvedCommitDescriptor(null, System.currentTimeMillis());
            }
            endCommit = UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)end, projectStorageSystemFactory);
            startCommit = new CommitDescriptor(endCommit.getBranchName(), endCommit.getTimestamp() - maxMillis);
        } else {
            startCommit = UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)start, projectStorageSystemFactory);
            endCommit = end != null ? UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)end, projectStorageSystemFactory) : new CommitDescriptor(startCommit.getBranchName(), System.currentTimeMillis());
        }
        return new TimeRange(startCommit, endCommit);
    }
}

