/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commit_trees.debug;

import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.commit_trees.debug.CommitTreeNodeData;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/commit-trees/debug/nodes")
public class CommitTreeNodesService
extends ApiBase {
    private static final String REPOSITORY_ID_PARAMETER_DESCRIPTION = "When provided will only dump the commit tree for the given repository, instead of all repository trees.";
    private static final String REPOSITORY_ID_PARAMETER_NAME = "repository-id";
    private static final String COMMIT_TREE_SUFFIX = "-commit-tree";

    @GET
    @Operation(summary="Get commit trees", description="Returns the commit tree data for a project. It excludes the nodes from the detailed commit tree. Use the debug/commit-tree service to get the full detailed information.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"application/json"})
    public List<CommitTreeNodeData> getDumpCommitTreeNodes(@Parameter(description="When provided will only dump the commit tree for the given repository, instead of all repository trees.") @QueryParam(value="repository-id") String repositoryId) throws StorageException {
        ArrayList<CommitTreeNodeData> result = new ArrayList<CommitTreeNodeData>();
        CommitTreeIndex.listCommitTrees((ProjectStorageSystem)this.getProjectStorageSystem()).forEach((storeName, commitTree) -> {
            if (!StringUtils.isEmpty((CharSequence)repositoryId) && !storeName.equals(repositoryId + COMMIT_TREE_SUFFIX)) {
                return;
            }
            result.addAll(CollectionUtils.map((Collection)commitTree.getAllNodes(), CommitTreeNodeData::new));
        });
        result.sort(Comparator.comparing(a -> a.commit).reversed());
        return result;
    }
}

