/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.cpp.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ambiguous_language.AmbiguousLanguageResolutionUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/cpp/debug/files-labeled-as-c-code")
public class DebugCppCodeDetectionHeuristicService
extends ApiBase {
    public static final String SHOW_CPP_CODE_FILES_PARAMETER = "showCppCodeFiles";
    public static final String PATHS_PARAMETER = "paths";

    @GET
    @Operation(summary="Retrieve files labeled as C++ code", description="Retrieves all files which are labeled (or not, depending on the service parameter) as C++ code by the heuristic.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public Set<String> retrieveFilesLabeledAsCCode(@QueryParam(value="showCppCodeFiles") @Parameter(description="Indicates whether those files labeled as C++ code should be retrieved or the ones not") @DefaultValue(value="true") boolean showCppCodeFiles, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor unresolvedCommitDescriptor, @QueryParam(value="paths") @Parameter(description="All paths which should be taken into account during the evaluation of the heuristic") List<String> paths) throws StorageException {
        TokenElementIndex index = this.openProjectIndex(TokenElementIndex.class, "content", this.determineHistoryOption(unresolvedCommitDescriptor));
        if (paths.isEmpty()) {
            return DebugCppCodeDetectionHeuristicService.evaluateHeuristicForEntries((PairList<String, TokenElementInfo>)index.getAllTokenElements(), showCppCodeFiles);
        }
        return DebugCppCodeDetectionHeuristicService.evaluateHeuristicForEntries((PairList<String, TokenElementInfo>)index.getEntriesByPathPrefix(paths), showCppCodeFiles);
    }

    private static Set<String> evaluateHeuristicForEntries(PairList<String, TokenElementInfo> entries, boolean showCppCodeFiles) {
        HashSet<String> filePaths = new HashSet<String>();
        for (Pair entry : entries) {
            boolean isCpp;
            String path = (String)entry.getFirst();
            boolean bl = isCpp = AmbiguousLanguageResolutionUtils.getLanguageFromUniformPath(Set.of(ELanguage.C, ELanguage.CPP), (String)((String)entry.getFirst()), (String)((TokenElementInfo)entry.getSecond()).getText()) == ELanguage.CPP;
            if ((isCpp || showCppCodeFiles) && (!isCpp || !showCppCodeFiles)) continue;
            filePaths.add(path);
        }
        return filePaths;
    }
}

