/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dashboard.widgets;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.index.dashboard.widgets.CodeCityNode;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderBase;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderParameters;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import java.awt.Color;
import java.util.List;
import java.util.regex.Pattern;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;

public class CodeCityBuilder
extends MetricTreemapBuilderBase<CodeCityNode> {
    private static final int MAX_ENTRIES_TO_SHOW = 30000;
    private Pair<Double, Double> heightRange;
    private final int heightMetricIndex;

    protected CodeCityBuilder(Pattern includePattern, Pattern excludePattern, IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, int colorMetricIndex, int heightMetricIndex, Object colorMetricDefault, Color baseColor, boolean enableColorBlindMode) {
        super(metricRetrievalStrategy, historyAccessOption, areaMetricIndex, new MetricTreemapBuilderParameters(includePattern, excludePattern, colorMetricIndex, colorMetricDefault, baseColor, enableColorBlindMode));
        this.heightMetricIndex = heightMetricIndex;
    }

    @Override
    protected CodeCityNode createNode(MetricDirectoryEntry entry) throws StorageException {
        Object heightValue = entry.getValue(this.heightMetricIndex);
        double height = 0.0;
        if (heightValue instanceof Long) {
            double range = (Double)this.heightRange.getSecond() - (Double)this.heightRange.getFirst();
            if (range > 0.0) {
                height = (double)((Long)heightValue).longValue() / range;
            }
        } else {
            height = (Double)CCSMAssert.checkedCast((Object)heightValue, Double.class) / (Double)this.heightRange.getSecond();
        }
        return new CodeCityNode(entry.getUniformPath(), entry.getDoubleValue(this.areaMetricIndex), height, entry.getValue(this.builderParameters.colorMetricIndex).toString(), this.formatMetricValue(heightValue), this.determineColor(entry));
    }

    @Override
    protected void determineValueRange(List<MetricDirectoryEntry> entries) throws TreeMapBuilderException {
        super.determineValueRange(entries);
        this.heightRange = this.determineValueRangeFromMetric(this.heightMetricIndex, entries);
    }

    @Override
    protected CodeCityNode buildTreeMapNodes(List<MetricDirectoryEntry> entries) throws StorageException, TreeMapBuilderException {
        if (entries.size() > 30000) {
            throw new TreeMapBuilderException("Too much data to show! Please reduce the amount of included data.");
        }
        return (CodeCityNode)super.buildTreeMapNodes(entries);
    }
}

