/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation.analysis_profile;

import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroupDifference;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfileDifference;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfileEditVersionComparison;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfileEditVersionComparisonUtils;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfileHistoryVersionComparison;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicatorDifference;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.configuration.AnalysisProfileVersionedIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/analysis-profiles/compare-versions/{analysisProfileName}")
public class AnalysisProfileEditHistoryVersionComparisonService
extends ApiBase {
    @GET
    @Operation(summary="Analysis profile version difference", description="Calculates and return the difference between an older edit version and a newer version of an analysis profile.")
    @RequiresBasicPermission(scope=EBasicPermissionScope.ANALYSIS_PROFILES, permissions={EBasicPermission.VIEW}, entityPathParameter="analysisProfileName")
    public AnalysisProfileHistoryVersionComparison getAnalysisEditHistoryVersionDiff(@PathParam(value="analysisProfileName") String analysisProfile, @QueryParam(value="newVersion") @Parameter(required=true, description="The version number of the newer version") int newVersion, @QueryParam(value="oldVersion") @Parameter(required=true, description="The version number of the older version") int oldVersion) throws StorageException {
        ConfigurationTemplate template;
        AnalysisProfileVersionedIndex analysisProfileVersionedIndex = (AnalysisProfileVersionedIndex)this.serviceInfo.getIndexLayer().openGlobalStorageSystem().openGlobalIndex(AnalysisProfileVersionedIndex.class);
        AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory editHistory = analysisProfileVersionedIndex.getAnalysisProfileVersionHistory(analysisProfile);
        if (editHistory == null || oldVersion >= newVersion) {
            return null;
        }
        AnalysisProfile newProfile = this.getNewAnalysisProfile(analysisProfile, newVersion, editHistory);
        try {
            template = ConfigRegistry.getInstance().createConfigurationTemplate((Set)newProfile.getLanguages(), (Set)newProfile.getTools(), this.getGlobalStorageSystem());
        }
        catch (ProjectConfigurationException e) {
            throw new BadRequestException("Unable to retrieve configuration template", (Throwable)e);
        }
        AnalysisProfile oldProfile = editHistory.getProfileForVersionNumber(oldVersion, this.getGlobalStorageSystem());
        AnalysisProfileHistoryVersionComparison difference = AnalysisProfileEditVersionComparison.getAnalysisProfileComparison((AnalysisProfile)oldProfile, (AnalysisProfile)newProfile);
        return AnalysisProfileEditHistoryVersionComparisonService.transformAllCheckIdsToReadableNames(difference, template);
    }

    private AnalysisProfile getNewAnalysisProfile(String analysisProfile, int newVersion, AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory editHistory) throws StorageException {
        if (newVersion >= editHistory.getLatestVersion().versionNumber()) {
            AnalysisProfileVersionedIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileVersionedIndex.class);
            return analysisProfileIndex.getProfile(analysisProfile, this.getGlobalStorageSystem());
        }
        return editHistory.getProfileForVersionNumber(newVersion, this.getGlobalStorageSystem());
    }

    private static AnalysisProfileHistoryVersionComparison transformAllCheckIdsToReadableNames(AnalysisProfileHistoryVersionComparison difference, ConfigurationTemplate template) {
        if (difference == null) {
            return null;
        }
        ArrayList<QualityIndicatorDifference> qualityIndicatorDifferences = new ArrayList<QualityIndicatorDifference>();
        for (QualityIndicatorDifference qualityIndicatorDifference : difference.profileDifference().qualityIndicatorDifference()) {
            List<AnalysisGroupDifference> analysisGroupDifferences = qualityIndicatorDifference.analysisGroupDifferences().stream().map(groupDifference -> AnalysisProfileEditHistoryVersionComparisonService.transformCheckIdsToReadableNamesWithValue(groupDifference.name(), groupDifference.addedChecks(), groupDifference.removedChecks(), groupDifference.changedCheckOption(), template)).toList();
            qualityIndicatorDifferences.add(new QualityIndicatorDifference(qualityIndicatorDifference.name(), qualityIndicatorDifference.oldName(), qualityIndicatorDifference.addedAnalysisGroups(), qualityIndicatorDifference.removedAnalysisGroups(), analysisGroupDifferences, qualityIndicatorDifference.changesOtherOptions()));
        }
        AnalysisProfileDifference analysisProfileDifferences = difference.profileDifference();
        AnalysisProfileDifference newAnalysisProfileDifferences = new AnalysisProfileDifference(analysisProfileDifferences.languagesAdded(), analysisProfileDifferences.languagesRemoved(), analysisProfileDifferences.toolsAdded(), analysisProfileDifferences.toolsRemoved(), analysisProfileDifferences.qualityIndicatorRenames(), analysisProfileDifferences.addedQualityIndicators(), analysisProfileDifferences.removedQualityIndicators(), qualityIndicatorDifferences, analysisProfileDifferences.changesOtherOptions(), analysisProfileDifferences.descriptionDiff());
        return new AnalysisProfileHistoryVersionComparison(newAnalysisProfileDifferences, difference.commonLanguages(), difference.commonTools());
    }

    private static AnalysisGroupDifference transformCheckIdsToReadableNamesWithValue(String analysisGroupName, List<String[]> addedChecks, List<String[]> removedChecks, List<String[]> difference, ConfigurationTemplate template) {
        AnalysisGroupDescriptor analysisGroup = template.getAnalysisGroup(analysisGroupName);
        List<String[]> transformedAddedChecks = addedChecks.stream().map(strings -> new String[]{AnalysisProfileEditVersionComparisonUtils.transformCheckIdToReadableNames((String)strings[0], (AnalysisGroupDescriptor)analysisGroup), strings[1]}).toList();
        List<String[]> transformedRemovedChecks = removedChecks.stream().map(strings -> new String[]{AnalysisProfileEditVersionComparisonUtils.transformCheckIdToReadableNames((String)strings[0], (AnalysisGroupDescriptor)analysisGroup), strings[1]}).toList();
        List<String[]> changedCheckOption = difference.stream().map(array -> new String[]{AnalysisProfileEditVersionComparisonUtils.transformCheckIdToReadableNames((String)array[0], (AnalysisGroupDescriptor)analysisGroup), array[1], array[2]}).toList();
        return new AnalysisGroupDifference(analysisGroupName, transformedAddedChecks, transformedRemovedChecks, changedCheckOption);
    }
}

