/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation.analysis_profile;

import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.service.documentation.DocumentationNodeBase;
import com.teamscale.service.documentation.analysis_profile.QualityIndicatorDocumentation;
import com.teamscale.service.documentation.layout.Layouter;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.string.StringUtils;

public class ProfileDocumentation
extends DocumentationNodeBase<QualityIndicatorDocumentation> {
    private List<QualityIndicatorDocumentation> qualityIndicators = new ArrayList<QualityIndicatorDocumentation>();

    public ProfileDocumentation(AnalysisProfile profile, List<QualityIndicatorDocumentation> qualityIndicatorDocumentations) {
        super(profile.getName(), ProfileDocumentation.buildDescription(profile));
        this.qualityIndicators = qualityIndicatorDocumentations;
    }

    private static String buildDescription(AnalysisProfile profile) {
        String languages = StringUtils.concat((Iterable)profile.getLanguages(), (String)", ");
        return "Includes checks for: " + languages + ".";
    }

    @Override
    protected List<QualityIndicatorDocumentation> getChildren() {
        return this.qualityIndicators;
    }

    @Override
    protected void layoutStart(Layouter layouter) {
        layouter.appendHeading("Analysis Profile: " + layouter.escape(this.readableName), 1);
        layouter.appendNewParagraph();
        if (!StringUtils.isEmpty((String)this.description)) {
            layouter.appendEscaped(this.description);
            layouter.appendNewParagraph();
        }
    }
}

