/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external;

import com.teamscale.core.authenticate.teamscale.accesskeys.AccessKeyHandler;
import com.teamscale.core.authenticate.teamscale.accesskeys.EncryptedAccessKeyIndex;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.PermissionCache;
import com.teamscale.core.permissions.PermissionFilter;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.UserPermissionsProvider;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.external.TeamscaleUploadWizardInput;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/ts-upload-wizard")
public class TeamscaleUploadWizardService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Input for the Teamscale Upload wizard.", description="Returns the input needed to render the Teamscale Upload wizard in the UI.")
    public TeamscaleUploadWizardInput getTeamscaleUploadWizardInput(@PathParam(value="project") PublicProjectId projectId) throws StorageException {
        return new TeamscaleUploadWizardInput(this.getUsersWithUploadPermission(projectId));
    }

    protected List<String> getUsersWithUploadPermission(PublicProjectId projectId) throws StorageException {
        UserIndex userIndex = this.openGlobalIndex(UserIndex.class);
        PermissionFilter filter = new PermissionFilter(this.getPermissions().getPermissionLookup(EBasicPermissionScope.USERS), User::getUsername, (Object)EBasicPermission.EDIT);
        List editableUsers = filter.filter(userIndex.getAllEntries().extractSecondList());
        SynchronizedCacheAccess permissionCacheAccess = this.getIndexLayer().getStorageCacheProvider().getCacheProvider("__global__").getCacheAccess(PermissionCache.class);
        PermissionIndex permissionIndex = this.openGlobalIndex(PermissionIndex.class);
        UserGroupIndex groupIndex = this.openGlobalIndex(UserGroupIndex.class);
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        UserPermissionsProvider userPermissionsProvider = new UserPermissionsProvider(groupIndex, permissionIndex, permissionCacheAccess);
        List usersWithUploadPermission = CollectionUtils.filterWithException((Collection)editableUsers, user -> TeamscaleUploadWizardService.hasUploadPermission(user, projectId, projectIndex, permissionIndex, userPermissionsProvider));
        return CollectionUtils.map((Collection)usersWithUploadPermission, User::getUsername);
    }

    private static boolean hasUploadPermission(User user, PublicProjectId projectId, ProjectIndex projectIndex, PermissionIndex permissionIndex, UserPermissionsProvider userPermissionsProvider) throws StorageException {
        ServicePermissions permissions = new ServicePermissions(userPermissionsProvider.getUserPermissions(user), (IProjectId)projectId, projectIndex, permissionIndex);
        return permissions.userHasProjectPermission(EProjectPermission.EXTERNAL_UPLOADS);
    }

    protected String createAndStoreEncryptedAccessKey(String userName) throws StorageException {
        UserIndex userIndex = this.openGlobalIndex(UserIndex.class);
        User uploadUser = userIndex.getUser(userName);
        if (uploadUser == null) {
            throw new NotFoundException("User with username " + userName + " was not found.");
        }
        this.getPermissions().checkBasicPermission(EBasicPermissionScope.USERS, uploadUser.getUsername(), EBasicPermission.EDIT);
        return AccessKeyHandler.createAndStoreEncryptedAccessKey((String)userName, (EncryptedAccessKeyIndex)this.openGlobalIndex(EncryptedAccessKeyIndex.class));
    }

    @GET
    @Path(value="ts-upload-invocation")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get a valid teamscale-upload invocation.", description="Allows the user to get a valid teamscale-upload invocation that the Teamscale Upload wizard UI created.")
    public String getTeamscaleUploadInvocation(@BeanParam TSUploadCommandRequest request) throws StorageException {
        String accessKey = this.createAndStoreEncryptedAccessKey(request.userName);
        return TeamscaleUploadWizardService.createTSUploadInvocation(request, this.serviceInfo.getRequestBaseUri(), accessKey);
    }

    private static String createTSUploadInvocation(TSUploadCommandRequest request, URI baseUrl, String userAccessKey) {
        StringBuilder invocation = new StringBuilder("teamscale-upload");
        invocation.append(" -s ").append(baseUrl);
        invocation.append(" -p ").append(request.projectId);
        invocation.append(" -u ").append(TeamscaleUploadWizardService.escapeInputParameters(request.userName));
        invocation.append(" -a ").append(userAccessKey);
        invocation.append(" -t ").append(TeamscaleUploadWizardService.wrapWithQuotationMarks(TeamscaleUploadWizardService.escapeInputParameters(request.partition)));
        invocation.append(" -f ").append(request.format.toString());
        return invocation.toString();
    }

    private static String escapeInputParameters(String input) {
        return StringUtils.escapeChars((String)input, (Map)CollectionUtils.asMap((Pair[])new Pair[]{Pair.createPair((Object)"\"", (Object)"\\\""), Pair.createPair((Object)"'", (Object)"\\'")}));
    }

    private static String wrapWithQuotationMarks(String input) {
        return StringUtils.surroundWith((String)input, (String)"\"", (String)"\"");
    }

    private static class TSUploadCommandRequest {
        @Parameter(required=true, description="The project ID to which the external coverage report should be uploaded")
        @PathParam(value="project")
        private PublicProjectId projectId;
        @Parameter(required=true, description="The Teamscale user which should be used to perform the upload")
        @QueryParam(value="user")
        private String userName;
        @Parameter(required=true, description="The partition in which to store the uploaded coverage in Teamscale")
        @QueryParam(value="partition")
        private String partition;
        @Parameter(required=true, description="The format of the external upload data")
        @QueryParam(value="format")
        private EReportFormat format;

        private TSUploadCommandRequest() {
        }
    }
}

