/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.debug;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.external.ExternalAnalysisCommitInfo;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.service.base.debug.DebugDumpServiceBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;

@Path(value="api/projects/{project}/external-analysis/debug/results")
public class DebugExternalAnalysisResultsService
extends DebugDumpServiceBase {
    private String tracePath;

    @GET
    @Path(value="{tracePath}")
    @Operation(summary="Get external analysis data", description="Returns the detail information of external analysis data for a project.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String getExternalAnalysisResult(@PathParam(value="tracePath") String tracePath) throws StorageException {
        this.tracePath = tracePath;
        return this.getDebugDumpResults();
    }

    @GET
    @Path(value="oldest-commit-for-upload-since")
    @Operation(summary="Get oldest commit timestamp for any upload since given timestamp", description="Returns the oldest commit timestamp for all uploads since a given timestamp over all partitions.", tags={"Debugging"})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Produces(value={"application/json"})
    public long getOldestCommitTimestampForUploadsSince(@QueryParam(value="timestamp") long timestamp) throws StorageException {
        List<ExternalAnalysisCommitInfo> commitInfos = this.loadCommitInfos();
        return commitInfos.stream().filter(commitInfo -> commitInfo.getUploadTimestamp() >= timestamp).map(CommitAssociatedObjectBase::getTimestamp).min(Long::compareTo).orElseGet(System::currentTimeMillis);
    }

    @Override
    protected void generateDump(PrintWriter writer) throws StorageException {
        List<ExternalAnalysisCommitInfo> commitInfos = this.loadCommitInfos();
        commitInfos.sort(Comparator.comparingLong(CommitAssociatedObjectBase::getTimestamp));
        for (ExternalAnalysisCommitInfo commitInfo : commitInfos) {
            if (commitInfo.getFileDelta().getAddedOrChangedKeysAsStrings().contains(this.tracePath)) {
                DebugExternalAnalysisResultsService.dumpInfo(commitInfo, "added/modified", writer);
                continue;
            }
            if (!commitInfo.getFileDelta().getDeletedKeysAsStrings().contains(this.tracePath)) continue;
            DebugExternalAnalysisResultsService.dumpInfo(commitInfo, "deleted", writer);
        }
    }

    private List<ExternalAnalysisCommitInfo> loadCommitInfos() throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.serviceInfo.getProjectStorageSystem();
        return ExternalAnalysisResultIndex.loadCommitInfos((IBranchingLayer)projectStorageSystem.openBranchingLayer(ExternalAnalysisResultIndex.class));
    }

    private static void dumpInfo(ExternalAnalysisCommitInfo commitInfo, String change, PrintWriter writer) {
        writer.println(String.valueOf(commitInfo.getCommit()) + " [" + commitInfo.getPartition() + "] " + change);
    }
}

