/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input;

import com.teamscale.core.analysis.configuration.index.model.EMetricSchemaSource;
import com.teamscale.core.concurrency.ExecuteInParallelBatchesFunction;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.report.generic.GenericNonCodeMetricsParser;
import com.teamscale.index.report.generic.NonCodeMetricsEntry;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.reportparser.parser.ReportParserException;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceBase;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

@Path(value="api/projects/{project}/external-analysis/session/{sessionId}/non-code-metrics")
public class NonCodeMetricUploadService
extends SessionBasedExternalAnalysisServiceBase<SessionBasedExternalAnalysisServiceQueryOptions> {
    private static final String NON_CODE_REPORT_FILE_NAME = "non-code-report";

    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Operation(summary="Upload non-code metrics", description="Adds non-code metrics to the session. For performance reasons, it is recommended to batch calls to this service, i.e. not commit all files using single calls.", tags={"External Analysis", "External Metrics"}, responses={@ApiResponse(responseCode="400", description="Partition name not provided."), @ApiResponse(responseCode="404", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="404", description="No session with provided id found."), @ApiResponse(responseCode="400", description="Provided partition name is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Provided upload message is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Session has been committed or deleted."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="400", description="No content provided."), @ApiResponse(responseCode="400", description="Invalid content provided.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public void uploadNonCodeMetrics(@Parameter(description="If session ID is provided, the results will be appended to the given session instead of creating a new session. Use \"auto-create\" in place of session ID to create a new session, perform upload and commit session in one step.") @PathParam(value="sessionId") String sessionId, @BeanParam SessionBasedExternalAnalysisServiceQueryOptions parameters, @RequestBody(required=true) List<NonCodeMetricsEntry> externalNonCodeMetrics) throws StorageException {
        ArrayList<NonCodeMetricsEntry> requestParts = new ArrayList<NonCodeMetricsEntry>(externalNonCodeMetrics);
        this.process(EHttpMethod.POST, requestParts, parameters, sessionId);
    }

    @Override
    protected void processRequest(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionIndex sessionIndex, List<IExternalUploadRequestPart> externalData, SessionBasedExternalAnalysisServiceQueryOptions parameters) throws StorageException {
        if (externalData.isEmpty()) {
            throw new BadRequestException("Empty content provided.");
        }
        if (session.getTargetStorage().isPresent()) {
            NonCodeMetricUploadService.processAndInsertUnparsedMetrics(session, sessionIndex, externalData);
            return;
        }
        HistoryAccessOption historyAccess = HistoryAccessOption.readTimestamp((String)session.getCommit().getBranchName(), (long)session.getCommit().getTimestamp());
        PathLookupIndex pathLookupIndex = this.openProjectIndex(PathLookupIndex.class, historyAccess);
        TokenElementIndexCache tokenElementCache = new TokenElementIndexCache(this.openProjectIndex(TokenElementIndex.class, "content", historyAccess), Collections.emptyList());
        TokenElementLineInfoIndex tokenElementLineInfoIndex = this.openProjectIndex(TokenElementLineInfoIndex.class, historyAccess);
        BinaryElementIndex binaryElementIndex = this.openProjectIndex(BinaryElementIndex.class, historyAccess);
        GenericNonCodeMetricsParser parser = new GenericNonCodeMetricsParser();
        parser.init(null, tokenElementCache, tokenElementLineInfoIndex, binaryElementIndex, (IMatchingPathsLookup)pathLookupIndex, null, null, null, null, false, ExecuteInParallelBatchesFunction.createSingleThreadedExecutor(), null);
        ArrayList<NonCodeMetricsEntry> metrics = new ArrayList<NonCodeMetricsEntry>();
        for (IExternalUploadRequestPart metric : externalData) {
            metrics.add((NonCodeMetricsEntry)metric);
        }
        try {
            parser.parse(metrics);
            sessionIndex.insertAndMergeImportInfos(session, Collections.singletonList(parser.getInfos()));
        }
        catch (ReportParserException e) {
            throw new BadRequestException("Invalid report: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void processAndInsertUnparsedMetrics(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionIndex sessionIndex, List<IExternalUploadRequestPart> externalData) throws StorageException {
        ExternalAnalysisImportInfoReport.Builder builder = new ExternalAnalysisImportInfoReport.Builder(EMetricSchemaSource.NON_CODE_METRICS.getPathPrefix(), EReportFormat.GENERIC_NON_CODE);
        builder.addReport(NON_CODE_REPORT_FILE_NAME, JsonUtils.serializeToJSON(externalData));
        sessionIndex.insertAndMergeImportInfos(session, Collections.singletonList(builder.build()));
    }
}

