/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import java.util.Optional;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="upload.max-age", name="The maximum upload age to accept. This option can prevent huge rollbacks by refusing uploads with timestamps too far in the past. A value of 0 will reject all uploads.", type=EOptionType.PROJECT, category=EOptionCategory.EXTERNAL_UPLOADS)
@IndexValueClass(containedInBackup=true)
public class RejectOldUploadsOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "upload.max-age";
    public static final String OPTION_NAME = "The maximum upload age to accept. This option can prevent huge rollbacks by refusing uploads with timestamps too far in the past. A value of 0 will reject all uploads.";
    @JsonProperty(value="maxUploadDays")
    @OptionFieldDescription(name="The maximum number of days an upload may be made back in time, which in turn may cause rollbacks. Leave empty to allow all uploads.")
    public String maxUploadDays = "";

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        if (StringUtils.isEmpty((String)this.maxUploadDays)) {
            return null;
        }
        try {
            int result = Integer.parseInt(this.maxUploadDays);
            if (result < 0) {
                return "Max number of days must be positive.";
            }
            return null;
        }
        catch (NumberFormatException e) {
            return "Invalid number. Please insert a number of days, e.g. '30'";
        }
    }

    public Optional<Integer> getMaxUploadDays() {
        if (StringUtils.isEmpty((String)this.maxUploadDays)) {
            return Optional.empty();
        }
        return Optional.of(Integer.parseInt(this.maxUploadDays));
    }
}

