/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input;

import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.external.DelayedExternalUploadIntegrationTrigger;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.LateExternalUploadScheduleOption;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.ExternalAnalysisSessionCreationUtils;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.IntegrateImportedAnalysisResultsTrigger;
import com.teamscale.index.external.input.UploadRejectedException;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackendIndex;
import com.teamscale.index.external.input.external_storage.ExternalStorageLookup;
import com.teamscale.index.external.input.external_storage.StoreAnalysisResultsInExternalStorageTrigger;
import com.teamscale.index.external.status.EExternalAnalysisProcessingStatus;
import com.teamscale.index.external.status.ExternalAnalysisProcessingStepInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.external.status.ExternalAnalysisStatusInfo;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.external.status.ExternalAnalysisStatusLogManager;
import com.teamscale.service.upload.base.ExternalUploadServiceBase;
import com.teamscale.service.upload.base.ExternalUploadServiceQueryOptions;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.lang.ObjectUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public abstract class SessionBasedExternalAnalysisServiceBase<S extends SessionBasedExternalAnalysisServiceQueryOptions>
extends ExternalUploadServiceBase<S> {
    public static final String SESSION_PARAMETER_NAME = "session";
    public static final String AUTO_CREATE_SESSION_PARAMETER = "auto-create";
    public static final String SESSION_ID_NOT_FOUND_ERROR = "No session with provided id found.";
    public static final String SESSION_DOES_NOT_EXIST_ERROR = "Session has been committed or deleted.";
    public static final String MODIFIED_UPLOAD_MESSAGE_ERROR = "Provided upload message is different from the one used to create the session.";
    public static final String MODIFIED_PARTITION_NAME_ERROR = "Provided partition name is different from the one used to create the session.";
    public static final String NO_PARTITION_NAME_PROVIDED_ERROR = "Partition name not provided.";
    public static final String NO_SESSION_FOUND_EXCEPTION_MESSAGE_PREFIX = "No session with ID";
    private static final String DATA_UPLOADED_SCHEDULING_REASON = "External analysis data was uploaded.";
    protected ExternalAnalysisStatusLogManager logManager = new ExternalAnalysisStatusLogManager();

    @Override
    protected IStore openExternalResultRawStore() throws StorageException {
        return this.openStoreInProject("external-analysis-results", ExternalAnalysisResultIndex.class);
    }

    protected final ExternalAnalysisSessionInfo process(EHttpMethod method, List<IExternalUploadRequestPart> requestBodyParts, S parameters, String sessionId) throws StorageException {
        Preconditions.checkArgument((sessionId != null ? 1 : 0) != 0, (Object)"Session ID must be part of URL or set to auto-create");
        this.logManager.logUploadStepInitiation(this.getClass(), this.getUser());
        this.logManager.logSessionId(sessionId);
        this.logManager.logParameters(method, (SessionBasedExternalAnalysisServiceQueryOptions)parameters);
        ExternalAnalysisStatusIndex statusIndex = this.openProjectIndex(ExternalAnalysisStatusIndex.class, null);
        ExternalAnalysisImportSessionIndex sessionIndex = this.openProjectIndex(ExternalAnalysisImportSessionIndex.class, null);
        ExternalAnalysisSessionInfo session = this.getOrCreateSession(parameters, sessionId, sessionIndex);
        SessionBasedExternalAnalysisServiceBase.checkParameters(session, parameters);
        try {
            this.processRequest(session, sessionIndex, requestBodyParts, parameters);
            if (sessionId.equals(AUTO_CREATE_SESSION_PARAMETER)) {
                this.commitSession(session, sessionIndex);
            }
            this.logManager.logSuccess();
            this.storeStatus(statusIndex, session, true);
        }
        catch (WebApplicationException | StorageException e) {
            this.logManager.logError(e);
            if (session != null) {
                SessionBasedExternalAnalysisServiceBase.deleteSession(session.getSessionId(), sessionIndex);
            }
            this.storeStatus(statusIndex, null, false);
            throw e;
        }
        return session;
    }

    protected abstract void processRequest(ExternalAnalysisSessionInfo var1, ExternalAnalysisImportSessionIndex var2, List<IExternalUploadRequestPart> var3, S var4) throws StorageException;

    private ExternalAnalysisSessionInfo getOrCreateSession(S parameters, String sessionId, ExternalAnalysisImportSessionIndex sessionIndex) throws StorageException, BadRequestException {
        if (sessionId.equals(AUTO_CREATE_SESSION_PARAMETER)) {
            this.requirePartition(parameters);
            return this.createNewSession(parameters);
        }
        return this.getOpenSession(sessionId, sessionIndex);
    }

    protected ExternalAnalysisSessionInfo createNewSession(S parameters) throws BadRequestException, StorageException {
        try {
            Optional targetStorage = ExternalStorageLookup.getStorageBackend((ProjectConfiguration)this.getProjectConfiguration(), (ExternalStorageBackendIndex)this.openGlobalIndex(ExternalStorageBackendIndex.class));
            ExternalAnalysisSessionInfo session = ExternalAnalysisSessionCreationUtils.createSession((ExternalAnalysisSessionCreationUtils.SessionParameters)this.convertSessionParameters(parameters, targetStorage), (InternalProjectId)this.serviceInfo.getInternalId(), (IndexLayer)this.getIndexLayer(), (String)this.getUser().getUsername(), x$0 -> this.shouldRejectUpload((CommitDescriptor)x$0), this::openExternalResultRawStore);
            LOGGER.trace("Logging session creation ...");
            this.logManager.logSessionCreation(session.getSessionId());
            return session;
        }
        catch (UploadRejectedException e) {
            throw this.getUploadRejectedException(e.getRejectedCommit());
        }
    }

    private @NonNull ProjectConfiguration getProjectConfiguration() throws StorageException {
        return (ProjectConfiguration)ObjectUtils.requireNonNullElseThrow((Object)ProjectConfigurationUtils.getProjectConfiguration((IProjectId)this.serviceInfo.getInternalId(), (IndexLayer)this.getIndexLayer()), () -> new NotFoundException("Project configuration with ID '%s (%s)' not found.".formatted(this.serviceInfo.getPrimaryPublicId(), this.serviceInfo.getInternalId())));
    }

    private ExternalAnalysisSessionCreationUtils.SessionParameters convertSessionParameters(S parameters, Optional<ExternalStorageBackend> externalStorage) {
        if (externalStorage.isPresent()) {
            ((ExternalUploadServiceQueryOptions)parameters).setCommit(SessionBasedExternalAnalysisServiceBase.roundTimestampToRelatedCodeCommit(((ExternalUploadServiceQueryOptions)parameters).getCommitAndRevision().commit()));
        }
        return new ExternalAnalysisSessionCreationUtils.SessionParameters(externalStorage, ((SessionBasedExternalAnalysisServiceQueryOptions)parameters).getPartition(), ((ExternalUploadServiceQueryOptions)parameters).getCommitAndRevision(), ((SessionBasedExternalAnalysisServiceQueryOptions)parameters).getUploadMessage(), ((SessionBasedExternalAnalysisServiceQueryOptions)parameters).isMoveToLastCommit(), ((ExternalUploadServiceQueryOptions)parameters).getRepositoryId());
    }

    private ExternalAnalysisSessionInfo getOpenSession(String sessionId, ExternalAnalysisImportSessionIndex sessionIndex) throws StorageException {
        ExternalAnalysisSessionInfo session = (ExternalAnalysisSessionInfo)sessionIndex.getSessionInfo(sessionId).orElseThrow(() -> new NotFoundException("No session with ID " + sessionId + " found!"));
        this.logManager.logSessionFetch(session.getSessionId());
        if (!session.isOpen()) {
            throw new BadRequestException("Session " + sessionId + " has been committed or deleted!");
        }
        return session;
    }

    protected ExternalAnalysisSessionInfo commitSession(String sessionId, ExternalAnalysisImportSessionIndex sessionIndex) throws NotFoundException, StorageException {
        ExternalAnalysisSessionInfo session = this.getOpenSession(sessionId, sessionIndex);
        this.commitSession(session, sessionIndex);
        return session;
    }

    private void commitSession(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionIndex sessionIndex) throws StorageException {
        this.logManager.logSessionCommit(session.getSessionId());
        session = this.updateSessionForExternalStorage(session);
        session.setCommitted();
        sessionIndex.setSessionInfo(session.getSessionId(), session);
        if (this.isLateUploadScheduleOptionConfigured() && this.isLateUpload(session)) {
            LOGGER.warn("Delaying late external upload: {}", (Object)session);
        } else if (sessionIndex.markSessionAsScheduled(session)) {
            this.scheduleJob(session);
        }
    }

    protected static ExternalAnalysisSessionInfo deleteSession(String sessionId, ExternalAnalysisImportSessionIndex sessionIndex) throws StorageException, NotFoundException {
        ExternalAnalysisSessionInfo sessionInfo = (ExternalAnalysisSessionInfo)sessionIndex.getSessionInfo(sessionId).orElseThrow(() -> new NotFoundException("Session with ID '" + sessionId + "' does not exist."));
        sessionIndex.deleteSession(sessionId);
        return sessionInfo;
    }

    private boolean isLateUpload(ExternalAnalysisSessionInfo session) throws StorageException {
        ServerOptionIndex serverOptionIndex;
        int ageThresholdMinutes;
        RepositoryLogIndex repositoryLogIndex;
        long latestCommitTimestamp;
        boolean isLateUpload;
        long timestamp = session.getCommit().getTimestamp();
        boolean bl = isLateUpload = timestamp < (latestCommitTimestamp = (repositoryLogIndex = this.openProjectIndex(RepositoryLogIndex.class, null)).getNewestTimestamp()) - Duration.ofMinutes(ageThresholdMinutes = LateExternalUploadScheduleOption.getAgeThreshold((ServerOptionIndex)(serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class)))).toMillis();
        if (isLateUpload) {
            LOGGER.warn("Marking upload as late: {}. Session timestamp is {} ({}), while newest processed commit timestamp is {} ({}), which exceeds the threshold of {} minute(s).", (Object)session.getRevision(), (Object)timestamp, (Object)DateTimeUtils.getUiFormattedDateString((long)timestamp), (Object)latestCommitTimestamp, (Object)DateTimeUtils.getUiFormattedDateString((long)latestCommitTimestamp), (Object)ageThresholdMinutes);
            if (latestCommitTimestamp > Instant.now().toEpochMilli()) {
                LOGGER.error("It seems that the latest commit timestamp is in the future. This can happen when integrating external data with future timestamps. Teamscale will hold off processing further uploads until they are within the \"late external upload\" age threshold of this upload again. Please check if this was intentional, or remove the future upload otherwise.");
            }
        }
        return isLateUpload;
    }

    private boolean isLateUploadScheduleOptionConfigured() throws StorageException {
        ServerOptionIndex serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        String uploadSchedule = LateExternalUploadScheduleOption.getUploadSchedule((ServerOptionIndex)serverOptionIndex);
        return !StringUtils.isEmpty((String)uploadSchedule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob(ExternalAnalysisSessionInfo session) throws StorageException {
        if (session.getTargetStorage().isPresent()) {
            StoreAnalysisResultsInExternalStorageTrigger.schedule((InternalProjectId)this.serviceInfo.getInternalId(), (IndexLayer)this.getIndexLayer(), (String)DATA_UPLOADED_SCHEDULING_REASON);
            return;
        }
        Lock lock = this.serviceInfo.getLockProvider().obtainLock(IntegrateImportedAnalysisResultsTrigger.class.getName());
        lock.lock();
        try {
            if (!DelayedExternalUploadIntegrationTrigger.isIntegrateTriggerAlreadyScheduled((CommitDescriptor)session.getCommit(), (IndexLayer)this.serviceInfo.getIndexLayer(), (InternalProjectId)this.serviceInfo.getInternalId())) {
                JobDescriptor job = new JobDescriptor(this.serviceInfo.getInternalId(), IntegrateImportedAnalysisResultsTrigger.class, session.getCommit(), DATA_UPLOADED_SCHEDULING_REASON);
                ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), job);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private ExternalAnalysisSessionInfo updateSessionForExternalStorage(ExternalAnalysisSessionInfo session) throws StorageException {
        if (session.getTargetStorage().isEmpty() || session.getRevision().isPresent()) {
            return session;
        }
        return this.guessRevisionAndRepository(session.getCommit()).map(revisionAndRepository -> session.newBuilder().withRevision(revisionAndRepository.revision()).withRepository(revisionAndRepository.repositoryIdentifier()).build()).orElse(session);
    }

    private Optional<RepositoryRevisionIndex.RevisionAndRepository> guessRevisionAndRepository(CommitDescriptor sessionCommit) throws StorageException {
        Optional<RepositoryRevisionIndex.RevisionAndRepository> result = this.openProjectIndex(RepositoryRevisionIndex.class, null).getAllKnownRepositoryRevisions().stream().filter(commitAndRevisionAndRepository -> sessionCommit.equals(commitAndRevisionAndRepository.getFirst())).map(ImmutablePair::getSecond).findAny();
        if (result.isEmpty()) {
            LOGGER.debug("Did not find a matching revision for session commit {} with guessed code commit {}", new Supplier[]{() -> sessionCommit, () -> sessionCommit});
        }
        return result;
    }

    private static UnresolvedCommitDescriptor roundTimestampToRelatedCodeCommit(UnresolvedCommitDescriptor commit) {
        return new UnresolvedCommitDescriptor(commit.getBranchName(), SessionBasedExternalAnalysisServiceBase.roundTimestampToRelatedCodeCommit(commit.getTimestamp()));
    }

    private static long roundTimestampToRelatedCodeCommit(long timestamp) {
        long timestampOffset = timestamp % 1000L;
        if (timestampOffset == 0L) {
            return timestamp;
        }
        if (timestampOffset > 500L) {
            return timestamp;
        }
        return timestamp - timestampOffset;
    }

    protected void storeStatus(ExternalAnalysisStatusIndex statusIndex, ExternalAnalysisSessionInfo session, boolean success) throws StorageException {
        if (session == null) {
            LOGGER.error("Failed to store status as no session was created before the first error!");
            return;
        }
        statusIndex.runWithLock(lockedIndex -> this.storeStatus((ExternalAnalysisStatusIndex.LockedIndexAccess)lockedIndex, session, success, session.getCommit()));
    }

    private void storeStatus(ExternalAnalysisStatusIndex.LockedIndexAccess lockedIndexAccess, ExternalAnalysisSessionInfo session, boolean success, CommitDescriptor sessionCommit) throws StorageException {
        ExternalAnalysisStatusInfo oldStatus = lockedIndexAccess.getStatus(sessionCommit);
        ExternalAnalysisStatusInfo status = ExternalAnalysisStatusInfo.copy((ExternalAnalysisStatusInfo)oldStatus, () -> {
            ExternalAnalysisStatusInfo created = new ExternalAnalysisStatusInfo(sessionCommit, true, session.getUploadTimestamp(), session.getTargetStorage().isPresent());
            created.addPartition(session.getPartition());
            return created;
        });
        status.setMessage(session.getMessage());
        ExternalAnalysisProcessingStepInfo step = new ExternalAnalysisProcessingStepInfo(EExternalAnalysisProcessingStatus.UPLOADED, success);
        step.addMessages(this.logManager.getProcessingMessages());
        status.addProcessingStep(step);
        lockedIndexAccess.updateStatusWithKnownOldStatus(oldStatus, status);
    }

    private static void checkParameters(ExternalAnalysisSessionInfo sessionInfo, SessionBasedExternalAnalysisServiceQueryOptions parameters) {
        String uploadMessage = parameters.getUploadMessage();
        if (uploadMessage != null && !uploadMessage.equals("External analysis data upload") && !parameters.getUploadMessage().equals(sessionInfo.getMessage())) {
            throw new BadRequestException("Provided upload message is different from the one used to create the session! Either provide the same upload message or skip it.");
        }
        String partition = parameters.getPartition();
        if (partition != null && !partition.equals(sessionInfo.getPartition())) {
            throw new BadRequestException("Provided partition name is different from the one used to create the session! Either provide the same partition name or skip it." + String.format("'%s' vs  '%s'", partition, sessionInfo.getPartition()));
        }
    }

    protected void requirePartition(S parameters) throws BadRequestException {
        if (((SessionBasedExternalAnalysisServiceQueryOptions)parameters).getPartition() == null) {
            throw new BadRequestException("Partition name must be provided.");
        }
    }
}

