/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.index.findings.calculation.FindingsServiceUtils;
import com.teamscale.index.issues.IssueHistoryIndex;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.repository.FirstLastCommit;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.index.tracking.index.FindingChurnListIndex;
import com.teamscale.index.utils.IssueUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import jakarta.ws.rs.NotFoundException;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class FindingChurnByIssueServiceBase
extends ApiBase {
    protected FindingChurnList getFindingChurn(String issueId, boolean removeBlacklistedFindings, boolean removeResolvedFindings) throws StorageException {
        TeamscaleIssueId parsedIssueId = this.getActualIssueId(issueId);
        RepositoryCommitIssueMappingIndex mappingIndex = this.openProjectIndex(RepositoryCommitIssueMappingIndex.class, null);
        List issueCommits = mappingIndex.getCommitsForIssue(parsedIssueId);
        String branch = this.determineIssueBranch(issueCommits);
        FindingChurnListIndex findingChurnListIndex = this.openProjectIndex(FindingChurnListIndex.class, null);
        FindingChurnList findingChurnList = removeBlacklistedFindings ? FindingsServiceUtils.getBlacklistAwareFindingChurnForIssue((ProjectStorageSystem)this.getProjectStorageSystem(), (TeamscaleIssueId)parsedIssueId, (String)branch, (RepositoryCommitIssueMappingIndex)mappingIndex, (boolean)removeResolvedFindings).orElse(FindingChurnByIssueServiceBase.createEmptyFindingsChurn(branch)) : FindingsServiceUtils.getFindingChurnForIssue((TeamscaleIssueId)parsedIssueId, (FindingChurnListIndex)findingChurnListIndex, (RepositoryCommitIssueMappingIndex)mappingIndex).orElse(FindingChurnByIssueServiceBase.createEmptyFindingsChurn(branch));
        FindingsServiceUtils.updateDeathCommitsAndLocations((ProjectStorageSystem)this.getProjectStorageSystem(), (String)branch, (FindingChurnList)findingChurnList);
        if (removeResolvedFindings) {
            findingChurnList.removeResolvedFindings();
        }
        return findingChurnList;
    }

    private TeamscaleIssueId getActualIssueId(String issueId) throws StorageException {
        IssueIndex issueIndex;
        IssueHistoryIndex issueHistoryIndex = this.openProjectIndex(IssueHistoryIndex.class, null);
        Optional issue = IssueUtils.getSingleIssueHistoryForId((IKeyedObjectIndex)issueHistoryIndex, (IssueIndexBase)(issueIndex = this.openProjectIndex(IssueIndex.class, null)), (String)issueId, (boolean)true);
        if (issue.isEmpty()) {
            throw new NotFoundException("Unknown issue with ID '" + issueId + "'.");
        }
        return ((TeamscaleIssue)issue.get()).getId();
    }

    private static FindingChurnList createEmptyFindingsChurn(String branch) {
        return new FindingChurnList(CommitDescriptor.latestOnBranch((String)branch));
    }

    private String determineIssueBranch(List<CommitDescriptor> issueCommits) throws StorageException {
        return Optional.ofNullable(FirstLastCommit.extractFromList(issueCommits)).map(firstLastCommit -> firstLastCommit.lastCommit.getBranchName()).orElse(this.getDefaultBranchName());
    }
}

