/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.index.tracking.ExtendedTrackedFinding;
import com.teamscale.service.base.ESortOrder;
import com.teamscale.service.findings.options.ESortProperty;
import com.teamscale.service.findings.options.FindingSortOptions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.NumbersAwareStringComparator;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class FindingsSortUtils {
    protected static void sortFindings(List<ExtendedTrackedFinding> filteredFindings, FindingSortOptions sortOptions) {
        if (StringUtils.isEmpty((String)sortOptions.getSortBy())) {
            return;
        }
        String sortBy = sortOptions.getSortBy();
        ESortProperty sortProperty = (ESortProperty)EnumUtils.valueOfIgnoreCase(ESortProperty.class, (String)sortBy);
        Comparator<ExtendedTrackedFinding> comparator = sortProperty != null ? sortProperty.createComparator() : FindingsSortUtils.createPropertyComparator(sortBy);
        filteredFindings.sort(comparator);
        if (sortOptions.getSortOrder() == ESortOrder.DESCENDING) {
            Collections.reverse(filteredFindings);
        }
    }

    private static Comparator<ExtendedTrackedFinding> createPropertyComparator(String sortBy) {
        return (f1, f2) -> {
            Object v1 = f1.getProperties().get(sortBy);
            Object v2 = f2.getProperties().get(sortBy);
            if (v1 instanceof Comparable && v2 instanceof Comparable) {
                int result = v1 instanceof String && v2 instanceof String ? NumbersAwareStringComparator.INSTANCE.compare((String)v1, (String)v2) : ((Comparable)v1).compareTo(v2);
                if (result == 0) {
                    return f1.compareTo((TrackedFinding)f2);
                }
                return result;
            }
            if (v1 instanceof Comparable) {
                return 1;
            }
            if (v2 instanceof Comparable) {
                return -1;
            }
            return f1.compareTo((TrackedFinding)f2);
        };
    }

    private FindingsSortUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

