/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.findings.calculation.ExtendedFindingsWithCount;
import com.teamscale.index.findings.calculation.FindingsFilterSettings;
import com.teamscale.index.findings.calculation.FindingsPaginationOptions;
import com.teamscale.service.findings.options.FindingSortOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.persistence.store.StorageException;

public interface IAbapElementFindingsServiceApi {
    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_5_6_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get all ABAP findings", description="Returns all findings for the given project.", tags={"Findings", "SAP"}, responses={@ApiResponse(responseCode="400", description="One of the filter options is invalid.")})
    public ExtendedFindingsWithCount getAbapFindings(@BeanParam FindingsFilterSettings var1, @BeanParam FindingSortOptions var2, @BeanParam FindingsPaginationOptions var3) throws StorageException;

    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_5_6_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="{objectType}/{objectName}")
    @Operation(summary="Get ABAP findings", description="Returns findings for an ABAP source object, function group, or project. The element is expected in the form OBJTYPE/OBJNAME, e.g. 'PROG/ZTEST' or 'FUGR/!ABC!MY_FUNCTION_GROUP'.", tags={"Findings", "SAP"}, responses={@ApiResponse(responseCode="400", description="One of the filter options is invalid.")})
    public ExtendedFindingsWithCount getAbapFindings(@PathParam(value="objectType") EAbapObjectType var1, @PathParam(value="objectName") @Parameter(description="Object name in Teamscale-specific encoding:\nReplace '!' with '#excl#', '/' with '!', '\\' with '#rsol#',  ':' with '#colon#',\n'<' with '#lt#', '>' with '#gt#', '|' with '#verbar#', '?' with '#quest#',\n'*' with '#ast#', '\"' with '#quot#', and ` ` with '#space#'. For example,\"!CQSE!CL_ABAP_UTIL\".\n") String var2, @BeanParam FindingsFilterSettings var3, @QueryParam(value="report-missing-objects") @Parameter(description="Whether missing source objects are logged in the service log.") @DefaultValue(value="true") boolean var4) throws StorageException;
}

