/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.debug;

import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.tracking.FindingChurnCount;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.index.tracking.index.FindingChurnCountIndex;
import com.teamscale.index.tracking.index.FindingChurnListIndex;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/findings/debug/finding-tracking-consistency.txt")
public class DebugFindingTrackingInfoService
extends ApiBase {
    private static final String FULL_HISTORY_PARAMETER = "full-history";
    private boolean hadErrors = false;
    private static final String DESCRIPTION = "This is a debugging endpoint that runs a couple of consistency checks on the findings and tracked findings of a life instance and reports the results in textual form. Calling this service can potentially be very slow on large instances.";

    @GET
    @Operation(summary="Perform findings consistency check", description="This is a debugging endpoint that runs a couple of consistency checks on the findings and tracked findings of a life instance and reports the results in textual form. Calling this service can potentially be very slow on large instances.", tags={"Debugging"}, responses={@ApiResponse(responseCode="404", description="No commits found!")})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String getFindingTrackingConsistency(@Parameter(description="If this is set to true, not only the head revision, but all revisions will be checked (very slow!).") @QueryParam(value="full-history") boolean isFullHistory) throws StorageException {
        StringBuilder responseText = new StringBuilder();
        RepositoryLogIndex logIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
        if (isFullHistory) {
            this.checkFullHistory(logIndex, responseText);
        } else {
            List allEntries = logIndex.getEntries(0L, 0x7FFFFFFFFFFFFFFEL);
            if (allEntries.isEmpty()) {
                throw new NotFoundException("No commits found!");
            }
            RepositoryLogEntryAggregate latest = (RepositoryLogEntryAggregate)CollectionUtils.getLast((List)allEntries);
            this.performChecks(latest.getRevision() + " (" + String.valueOf(latest.getCommit()) + ")", latest.getCommit(), HistoryAccessOption.readHead((String)latest.getCommit().getBranchName()), responseText);
        }
        return responseText.toString();
    }

    private void checkFullHistory(RepositoryLogIndex logIndex, StringBuilder responseText) throws StorageException {
        for (RepositoryLogEntryAggregate logEntry : logIndex.getEntries(0L, 0x7FFFFFFFFFFFFFFEL)) {
            this.hadErrors = false;
            this.performChecks("rev. " + logEntry.getRevision(), logEntry.getCommit(), HistoryAccessOption.readTimestamp((String)logEntry.getCommit().getBranchName(), (long)logEntry.getTimestamp()), responseText);
        }
    }

    private void performChecks(String revisionName, CommitDescriptor commit, HistoryAccessOption historyAccessOption, StringBuilder responseText) throws StorageException {
        responseText.append("Checking consistency in " + revisionName + " @ " + String.valueOf(commit) + ": ");
        this.checkChurnConsistency(commit, responseText);
        this.checkFindingsConsistency(historyAccessOption, responseText);
        if (!this.hadErrors) {
            responseText.append("consistent");
        }
        responseText.append("\n");
    }

    private void checkChurnConsistency(CommitDescriptor commit, StringBuilder responseText) throws StorageException {
        String listString;
        FindingChurnCountIndex churnCountIndex = this.openProjectIndex(FindingChurnCountIndex.class, null);
        FindingChurnListIndex churnListIndex = this.openProjectIndex(FindingChurnListIndex.class, null);
        FindingChurnList churnList = (FindingChurnList)churnListIndex.getEntry(commit);
        FindingChurnCount churnCount = (FindingChurnCount)churnCountIndex.getEntry(commit);
        if (churnList == null && churnCount == null) {
            return;
        }
        if (churnList == null) {
            this.error("Churn list not available", responseText);
            return;
        }
        if (churnCount == null) {
            this.error("Churn count not available", responseText);
            return;
        }
        String countString = DebugFindingTrackingInfoService.formatChurn(churnCount.getAddedFindings(), churnCount.getRemovedFindings());
        if (!countString.equals(listString = DebugFindingTrackingInfoService.formatChurn(churnList.getAddedFindings().size(), churnList.getRemovedFindings().size()))) {
            this.error("Churn inconsistent: count is '" + countString + "' while list is '" + listString + "'", responseText);
        }
    }

    private static String formatChurn(int addedFindings, int removedFindings) {
        return "added: " + addedFindings + ", removed: " + removedFindings;
    }

    private void checkFindingsConsistency(HistoryAccessOption historyAccessOption, StringBuilder responseText) throws StorageException {
        ListMap trackedFindings = new ListMap();
        TrackedFindingsIndex trackedFindingsIndex = this.openProjectIndex(TrackedFindingsIndex.class, historyAccessOption);
        DebugFindingTrackingInfoService.appendFindings(trackedFindingsIndex.getAllEntries().mapSecond(x -> x), (ListMap<String, String>)trackedFindings);
        ListMap<String, String> originFindings = this.extractOriginFindings(historyAccessOption);
        HashSet trackedOnlyKeys = new HashSet(trackedFindings.getKeys());
        trackedOnlyKeys.removeAll((Collection<?>)originFindings.getKeys());
        if (!trackedOnlyKeys.isEmpty()) {
            this.error("The following paths have tracked findings but no origin findings: " + StringUtils.concat(trackedOnlyKeys, (String)", "), responseText);
        }
        this.checkConsistencyOnListMaps((ListMap<String, String>)trackedFindings, originFindings, responseText);
    }

    private ListMap<String, String> extractOriginFindings(HistoryAccessOption historyAccessOption) throws StorageException {
        ListMap originFindings = new ListMap();
        FindingsIndex findingsIndex = this.openProjectIndex(FindingsIndex.class, historyAccessOption);
        DebugFindingTrackingInfoService.appendFindings(findingsIndex.getAllUniformPathsAndFindings(), (ListMap<String, String>)originFindings);
        return originFindings;
    }

    private void checkConsistencyOnListMaps(ListMap<String, String> trackedFindings, ListMap<String, String> originFindings, StringBuilder responseText) {
        for (String key : originFindings.getKeys()) {
            List<String> trackedList;
            List<String> originList = DebugFindingTrackingInfoService.sortAndCheckNull((List)originFindings.getCollection((Object)key));
            if (originList.equals(trackedList = DebugFindingTrackingInfoService.sortAndCheckNull((List)trackedFindings.getCollection((Object)key)))) continue;
            this.error("Inconsistent entries for " + key + ":", responseText);
            for (String origin : originList) {
                this.error("   origin: " + origin, responseText);
            }
            for (String tracked : trackedList) {
                this.error("   tracked: " + tracked, responseText);
            }
        }
    }

    private static List<String> sortAndCheckNull(List<String> list) {
        if (list == null) {
            return CollectionUtils.emptyList();
        }
        return CollectionUtils.sort(list);
    }

    private static <T extends DetachedFinding> void appendFindings(PairList<String, List<T>> entries, ListMap<String, String> findings) {
        for (int i = 0; i < entries.size(); ++i) {
            String path = (String)entries.getFirst(i);
            List list = (List)entries.getSecond(i);
            if (list == null) continue;
            for (DetachedFinding finding : list) {
                findings.add((Object)path, (Object)DebugFindingTrackingInfoService.convertFinding(finding));
            }
        }
    }

    private static String convertFinding(DetachedFinding finding) {
        return finding.getLocationString() + ": " + finding.getCategoryName() + "/" + finding.getGroupName() + ": " + finding.getMessage();
    }

    private void error(String message, StringBuilder responseText) {
        this.hadErrors = true;
        responseText.append("\n   ");
        responseText.append(message);
    }
}

