/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.debug;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.task.ETaskStatus;
import com.teamscale.index.task.FindingIdWithBranch;
import com.teamscale.index.task.Task;
import com.teamscale.index.task.TaskIndex;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/findings/debug/id-consistency")
public class DebugFindingsIdConsistencyService
extends ApiBase {
    @GET
    @Operation(summary="Get a textual list of all finding ids which are inconsistent.", description="Get a textual list of all finding ids which are inconsistent.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String checkFindingsIdConsistency(@QueryParam(value="status") @Parameter(description="Only tasks with the given status will be checked.") List<ETaskStatus> status) throws StorageException {
        EnumSet<ETaskStatus> allowedStatus = status != null && !status.isEmpty() ? EnumSet.copyOf(status) : EnumSet.allOf(ETaskStatus.class);
        StringBuilder result = new StringBuilder();
        ProjectIndex projectIndex = (ProjectIndex)this.getGlobalStorageSystem().openGlobalIndex(ProjectIndex.class);
        for (ProjectInfo projectInfo : projectIndex.getAllProjectInfos()) {
            CommitResolvingStorageSystem projectStorage = this.getProjectStorageSystem(projectInfo);
            String defaultBranch = Optional.ofNullable(projectInfo.getPreselectedUIBranch()).orElse(((MetaIndex)projectStorage.openProjectIndex(MetaIndex.class, null)).getDefaultBranchName());
            TaskIndex taskIndex = (TaskIndex)projectStorage.openProjectIndex(TaskIndex.class, null);
            ListMap inconsistentTasks = new ListMap();
            for (Task task : taskIndex.getAllTasks()) {
                if (!allowedStatus.contains(task.getStatus()) || DebugFindingsIdConsistencyService.checkIfTaskIsConsistent(projectStorage, task, defaultBranch)) continue;
                inconsistentTasks.add((Object)task.getStatus(), (Object)task);
            }
            this.appendProjectInconsistencies(result, projectInfo, (ListMap<ETaskStatus, Task>)inconsistentTasks);
        }
        return result.toString();
    }

    private static boolean checkIfTaskIsConsistent(CommitResolvingStorageSystem projectStorage, Task task, String defaultBranch) throws StorageException {
        Map<String, List<FindingIdWithBranch>> findingsPerBranch = task.getFindings().stream().collect(Collectors.groupingBy(finding -> finding.getBranchName().orElse(defaultBranch)));
        ArrayList<String> unknownFindings = new ArrayList<String>();
        for (Map.Entry<String, List<FindingIdWithBranch>> entry : findingsPerBranch.entrySet()) {
            String branch = entry.getKey();
            List<String> findingIds = entry.getValue().stream().map(FindingIdWithBranch::getFindingId).toList();
            TrackedFindingsByIdIndex findingsByIdIndex = (TrackedFindingsByIdIndex)projectStorage.openProjectIndex(TrackedFindingsByIdIndex.class, HistoryAccessOption.readHead((String)branch));
            PairList findings = PairList.zip(findingIds, (List)findingsByIdIndex.getFindings(findingIds));
            for (Pair pair : findings) {
                if (pair.getSecond() != null) continue;
                unknownFindings.add((String)pair.getFirst());
            }
        }
        if (unknownFindings.isEmpty()) {
            return true;
        }
        TrackedFindingsByIdIndex findingsByIdIndex = (TrackedFindingsByIdIndex)projectStorage.openProjectIndex(TrackedFindingsByIdIndex.class, HistoryAccessOption.readHead((String)defaultBranch));
        return findingsByIdIndex.getFindings(unknownFindings).stream().allMatch(Objects::nonNull);
    }

    private void appendProjectInconsistencies(StringBuilder result, ProjectInfo projectInfo, ListMap<ETaskStatus, Task> inconsistentTasks) {
        if (inconsistentTasks.isEmpty()) {
            return;
        }
        result.repeat("=", 100).append("\n");
        result.append(projectInfo.getName()).append(" (").append(projectInfo.getPrimaryPublicId()).append(")\n");
        result.repeat("=", 100).append("\n");
        for (ETaskStatus value : ETaskStatus.values()) {
            List tasks = (List)inconsistentTasks.getCollectionOrEmpty((Object)value);
            if (tasks.isEmpty()) continue;
            result.append("\n");
            result.append(value.getReadableName()).append("\n");
            result.repeat("-", 100).append("\n");
            tasks.forEach(task -> result.append(this.serviceInfo.getRequestBaseUri()).append("qualitycontrol/tasks/").append(projectInfo.getPrimaryPublicId()).append("?id=").append(task.getId()).append("\n"));
        }
        result.append("\n\n");
    }
}

