/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.powershellscriptanalyzer.debug;

import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.impl.analysis.TriggerIndex;
import com.teamscale.index.findings.powershellscriptanalyzer.PowerShellScriptAnalyzerRunner;
import com.teamscale.index.findings.powershellscriptanalyzer.PowerShellScriptAnalyzerSynchronizer;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.SetupVerificationServiceUtils;
import com.teamscale.service.findings.clangtidy.ToolSetupDebugServiceUtils;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.reflect.TypeConversionException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/powershell-script-analyzer/debug/execution-setup")
public class DebugPowerShellScriptAnalyzerSetupService
extends ApiBase {
    private static final String TARGET_DIRECTORY_PARAM_NAME = "targetDir";
    private static final String TARGET_DIRECTORY_PARAM_DESCRIPTION = "The directory in which the service will store the execution environment. All current files in the directory will be deleted. The service requires admin permission since this can be abused.";

    @GET
    @Path(value="{uniformPath: .*}")
    @Operation(summary="Stores a PowerShellScriptAnalyzer execution setup for the given uniform path in the given directory. The stored .txt file contains the exact command we execute to run PowerShellScriptAnalyzer.", description="Stores a PowerShellScriptAnalyzer execution setup for the given uniform path in the given directory.", tags={"Source Code"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String storeExecutionSetup(@PathParam(value="uniformPath") UniformPath uniformPath, @QueryParam(value="targetDir") @Parameter(description="The directory in which the service will store the execution environment. All current files in the directory will be deleted. The service requires admin permission since this can be abused.") String directoryPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException, IOException, TypeConversionException {
        TokenElementIndex contentIndex = this.openProjectIndex(TokenElementIndex.class, "content", this.determineHistoryOption(commit));
        TokenElementInfo subjectElement = contentIndex.getTokenElement(uniformPath);
        if (subjectElement == null) {
            throw new IllegalArgumentException("Could not find file " + String.valueOf(uniformPath) + " in commit " + String.valueOf(commit));
        }
        CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement((BasicTokenElementInfo)subjectElement);
        File targetDir = SetupVerificationServiceUtils.setupCleanTargetDir(directoryPath);
        TriggerDescription.Parameters triggerParameters = this.determineTriggerProperties().getTriggerParameters();
        CodeScopeAware<PairList<String, String>> checkOptions = ToolSetupDebugServiceUtils.loadCodeScopeAwarePairListParameter((TriggerDescription.Parameters<String>)triggerParameters, "check-options", codeScopeName);
        CodeScopeAware<List<String>> selectedChecks = ToolSetupDebugServiceUtils.loadCodeScopeAwareListParameter((TriggerDescription.Parameters<String>)triggerParameters, "checks", codeScopeName);
        PowerShellScriptAnalyzerRunner runner = new PowerShellScriptAnalyzerRunner(new TokenElementIndexCache(contentIndex, Collections.emptyList()), this.resolve(commit), checkOptions.map(PairList::toMap));
        runner.prepareAndRunPowerShellScriptAnalyzer(Collections.singletonList(subjectElement), (File)new CanonicalFile(targetDir), selectedChecks, true);
        return "Prepared the setup in " + directoryPath + ". Execute the command stored in the .txt file to run the setup.";
    }

    private TriggerDescription determineTriggerProperties() throws StorageException {
        TriggerDescription powerShellScriptAnalyzerTriggerDescriptor = this.openProjectIndex(TriggerIndex.class, null).getTrigger(PowerShellScriptAnalyzerSynchronizer.class.getSimpleName());
        if (powerShellScriptAnalyzerTriggerDescriptor == null) {
            throw new IllegalArgumentException("Did not find a PowerShellScriptAnalyzerSynchronizer to determine enabled checks and options.");
        }
        CCSMAssert.isTrue((boolean)powerShellScriptAnalyzerTriggerDescriptor.getTriggerParameters().getParameterKeys().containsAll(Arrays.asList("checks", "check-options")), (String)"Options of PowerShellScriptAnalyzerSynchronizer have been renamed.");
        return powerShellScriptAnalyzerTriggerDescriptor;
    }
}

