/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.git.debug;

import com.teamscale.core.debug.DebugDumperRegistry;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.HashMap;
import java.util.Map;

@Path(value="api/git/debug/information/configuration")
public class DebugGitInformationDumpConfigurationService
extends ApiBase {
    @GET
    @Operation(summary="Get git debug dumper configuration", description="Lists the currently set parameters of the git debug dumper.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public Map<String, Object> getGitDebugDumperConfiguration() {
        HashMap<String, Object> debugDumpConfiguration = new HashMap<String, Object>();
        debugDumpConfiguration.put("enabled", DebugDumperRegistry.isEnabled());
        debugDumpConfiguration.put("anonymize", DebugDumperRegistry.isAnonymizationEnabled());
        debugDumpConfiguration.put("path", DebugDumperRegistry.getPath());
        debugDumpConfiguration.put("projects", DebugDumperRegistry.getProjectsPattern());
        debugDumpConfiguration.put("event", DebugDumperRegistry.getEventsPattern());
        return debugDumpConfiguration;
    }

    @POST
    @Operation(summary="Configure git debug dumper", description="Set parameters of the git debug dumper configuration. Minimally, enabled=true and path=/some/path need to be set if the debug dumper should be active. Optionally, projects=(project1|project2) to restrict this further.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void configureGitDebugDumper(@Parameter(description="Whether to enable the git debug dumper") @QueryParam(value="enabled") Boolean enabled, @Parameter(description="Whether to additionally output an anonymized debug dump (useful when you may not give out data such as names of repository branches or commit messages)") @QueryParam(value="anonymize") Boolean anonymizationEnabled, @Parameter(description="The server path where the debug dump files should be placed") @QueryParam(value="path") String path, @Parameter(description="The include regex for project IDs (if not set, all projects are accepted)") @QueryParam(value="projects") String projectsPattern, @Parameter(description="The include regex for potential dump events (see type EDebugDumpEvent, if not set, all events are accepted)") @QueryParam(value="event") String eventsPattern) {
        if (enabled != null) {
            DebugDumperRegistry.setEnabled((boolean)enabled);
        }
        if (anonymizationEnabled != null) {
            DebugDumperRegistry.setAnonymizationEnabled((boolean)anonymizationEnabled);
        }
        if (path != null) {
            DebugDumperRegistry.setPath((String)path);
        }
        if (projectsPattern != null) {
            DebugDumperRegistry.setProjectsPattern((String)projectsPattern);
        }
        if (eventsPattern != null) {
            DebugDumperRegistry.setEventsPattern((String)eventsPattern);
        }
    }

    @POST
    @Path(value="reset")
    @Operation(summary="Reset git debug dumper configuration", description="Resets git debug dumper configuration to system properties, i.e. reverts all custom settings that were introduced during runtime", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void resetGitDebugDumperConfiguration() {
        DebugDumperRegistry.initFromSystemProperties();
    }
}

