/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.github.debug;

import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndexSynchronizer;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;

@Path(value="api/github/debug/installation-index")
public class DebugGitHubInstallationIndexService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Get the GitHub installations content", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String getIndexContent() throws StorageException {
        GitHubInstallationIndex index = this.openGlobalIndex(GitHubInstallationIndex.class);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Organisation/User -> Installations:\n");
        stringBuilder.append(index.getAllOrganisationInstallations().toString());
        stringBuilder.append("\nInstallation -> App ID:\n");
        stringBuilder.append(index.getAllAppInstallations());
        stringBuilder.append("\nInstallation -> Repositories:\n");
        stringBuilder.append(index.getAllRepositoryInstallations());
        stringBuilder.append("\nApp ID -> Installations:\n");
        stringBuilder.append(index.getAllInstalledApps());
        return stringBuilder.toString();
    }

    @POST
    @Operation(summary="Synchronizes the GitHub installation index along all integrated GitHub applications.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void synchronizeIndex() throws StorageException {
        GitHubInstallationIndex installationIndex = this.openGlobalIndex(GitHubInstallationIndex.class);
        ServerOptionIndex optionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        AccessTokenIndex accessTokenIndex = this.openGlobalIndex(AccessTokenIndex.class);
        GitHubInstallationIndexSynchronizer.performFullInstallationIndexSynchronisation((ServerOptionIndex)optionIndex, (GitHubInstallationIndex)installationIndex, (AccessTokenIndex)accessTokenIndex, (Logger)LOGGER);
    }

    @DELETE
    @Operation(summary="Clears the entire index", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void clearIndex() throws StorageException {
        StorageUtils.clearStore((IStore)this.getGlobalStorageSystem().openStore("github-installations"));
    }
}

