/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.issues.IssueHistoryIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/issues/debug/dump-issue-history-index")
public class DebugDumpIssueHistoryIndexService
extends ApiBase {
    @GET
    @Operation(tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String dumpIssueHistoryIndex(@QueryParam(value="t") @Parameter(required=true) UnresolvedCommitDescriptor commit) throws StorageException {
        long timestampOrNow = this.determineHistoryOption(commit).getTimestampOrNow();
        StringBuilder outputBuilder = new StringBuilder();
        IssueHistoryIndex issueHistoryIndex = this.openProjectIndex(IssueHistoryIndex.class, null);
        TreeMap allIssueHistoryEntries = new TreeMap(issueHistoryIndex.getLookup());
        for (Map.Entry issueHistoryById : allIssueHistoryEntries.entrySet()) {
            List<String> includedTimestamps = ((List)issueHistoryById.getValue()).stream().filter(timestamp -> timestamp <= timestampOrNow).map(String::valueOf).toList();
            if (includedTimestamps.isEmpty()) continue;
            outputBuilder.append((String)issueHistoryById.getKey()).append(" => ").append(String.join((CharSequence)"; ", includedTimestamps)).append("\n");
        }
        return outputBuilder.toString();
    }
}

