/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.findings.calculation.BasicFindingsFilterSettings;
import com.teamscale.index.findings.calculation.FilteredFindingDelta;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.merge_request.MergeRequestFindingChurnCalculator;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.service.base.TimeRange;
import com.teamscale.service.commits.DirectedCommitDeltaServiceBase;
import com.teamscale.service.findings.ExcludedFindingsUtils;
import com.teamscale.service.findings.ExtendedFindingDeltaWithExcludedFindings;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/merge-requests/finding-churn")
public class MergeRequestFindingChurnService
extends DirectedCommitDeltaServiceBase {
    @Context
    private ResourceContext resourceContext;

    @GET
    @Operation(summary="Get merge request finding churn", description="Creates a findings delta (newly added or deleted findings and unchanged findings in modified code) for a given proposed merge. Findings in modified code will only be reported if the modification happened since the last common commit with the target branch.", tags={"Merge Requests", "Findings"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public ExtendedFindingDeltaWithExcludedFindings getMergeRequestFindingChurn(@Parameter(description="The source commit descriptor.", required=true) @QueryParam(value="source") UnresolvedCommitDescriptor unresolvedSourceCommit, @Parameter(description="The target commit descriptor.", required=true) @QueryParam(value="target") UnresolvedCommitDescriptor unresolvedTargetCommit, @Parameter(description="Key of a precomputed merge-base info object.") @QueryParam(value="merge-base-cache-key") String cacheKey, @BeanParam BasicFindingsFilterSettings filterSettings) throws StorageException {
        CommitDescriptor sourceCommit = this.resolve(unresolvedSourceCommit);
        CommitDescriptor targetCommit = this.resolve(unresolvedTargetCommit);
        MergeBaseInfo mergeBaseInfo = this.getMergeBaseInfo(sourceCommit, targetCommit, cacheKey);
        FindingsCalculationInfo calculationInfo = new FindingsCalculationInfo(this.serviceInfo.getPrimaryPublicId(), (ProjectStorageSystem)this.serviceInfo.getProjectStorageSystem(), this.serviceInfo.getIndexLayer());
        FilteredFindingDelta findingDelta = MergeRequestFindingChurnCalculator.getFindingDeltaForMerge((CommitDescriptor)sourceCommit, (CommitDescriptor)targetCommit, (BasicFindingsFilterSettings)filterSettings, (FindingsCalculationInfo)calculationInfo, (MergeBaseInfo)mergeBaseInfo);
        ExcludedFindingsUtils.ExcludedFindingsDelta excludedFindingsDelta = ExcludedFindingsUtils.getExcludedFindingsDelta(cacheKey, UniformPath.codeRoot(), new TimeRange(sourceCommit, targetCommit), filterSettings, this.resourceContext, calculationInfo);
        return ExtendedFindingDeltaWithExcludedFindings.create(findingDelta, excludedFindingsDelta, calculationInfo);
    }
}

