/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.threshold_path;

import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdIdentifier;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.metrics.threshold.EvaluatedMetricThresholdPath;
import com.teamscale.index.metrics.threshold.MetricThresholdSelectionUtils;
import com.teamscale.index.thresholds.ProjectThresholdConfigurationUtils;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.metrics.threshold_path.MetricThresholdConfigurationIndexLastChangeContributor;
import com.teamscale.service.metrics.threshold_path.MetricThresholdPathServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Optional;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/metric-threshold-path-for-metric")
public class MetricThresholdPathForMetricService
extends MetricThresholdPathServiceBase {
    public static final String METRIC_NAME_PARAMETER = "metricName";
    public static final String PATH_PARAMETER = "path";

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Provides threshold path for a metric.", description="Provides the time course for a given metric threshold configuration and metric.")
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, MetricThresholdConfigurationIndexLastChangeContributor.class})
    public EvaluatedMetricThresholdPath getMetricThresholdPathForMetric(@Parameter(description="Threshold configuration name.", required=true) @QueryParam(value="configuration") String thresholdConfigurationName, @Parameter(description="Metric name.", required=true) @QueryParam(value="metricName") String metricName, @Parameter(description="Path parameter.", required=true, allowEmptyValue=true) @QueryParam(value="path") String path) throws StorageException, MetricThresholdConfigurationException {
        MetricThresholdConfiguration thresholdConfiguration = ProjectThresholdConfigurationUtils.getThresholdConfiguration((String)thresholdConfigurationName, (IStorageInfo)this.serviceInfo, (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
        Optional thresholdIdentifier = MetricThresholdSelectionUtils.findBestMatchingThresholdInConfiguration((MetricThresholdConfiguration)thresholdConfiguration, (String)metricName, (String)path);
        if (thresholdIdentifier.isEmpty()) {
            return null;
        }
        return this.computeThresholdPath(thresholdConfigurationName, (MetricThresholdIdentifier)thresholdIdentifier.get());
    }
}

