/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.threshold_path;

import com.teamscale.core.analysis.configuration.index.model.MetricThresholdIdentifier;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.metrics.threshold.EvaluatedMetricThresholdPath;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.metrics.threshold_path.MetricThresholdConfigurationIndexLastChangeContributor;
import com.teamscale.service.metrics.threshold_path.MetricThresholdPathServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/metric-threshold-path-for-threshold")
public class MetricThresholdPathForThresholdService
extends MetricThresholdPathServiceBase {
    public static final String THRESHOLD_GROUP_NAME_PARAMETER = "thresholdGroupName";
    public static final String THRESHOLD_DISPLAY_NAME_PARAMETER = "thresholdDisplayName";

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Provides threshold path for a configuration.", description="Provides the time course for a given metric threshold configuration and metric.")
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, MetricThresholdConfigurationIndexLastChangeContributor.class})
    public EvaluatedMetricThresholdPath getThresholdPath(@Parameter(description="Threshold group name.", required=true) @QueryParam(value="thresholdGroupName") String thresholdGroupName, @Parameter(description="Threshold display name.", required=true) @QueryParam(value="thresholdDisplayName") String thresholdDisplayName, @Parameter(description="Threshold configuration name.", required=true) @QueryParam(value="configuration") String thresholdConfigurationName) throws StorageException {
        return this.computeThresholdPath(thresholdConfigurationName, new MetricThresholdIdentifier(thresholdGroupName, thresholdDisplayName));
    }
}

