/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.monitoring.prometheus.collectors;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.license.LicenseManager;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserLastActivityIndex;
import com.teamscale.index.usage_data.UsageDataCollector;
import com.teamscale.service.monitoring.prometheus.collectors.IndexCallbackMetricsProviderBase;
import io.prometheus.metrics.core.metrics.GaugeWithCallback;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.SupplierWithException;

public class UserMetricsCollector
extends IndexCallbackMetricsProviderBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public UserMetricsCollector(IndexLayer indexLayer) {
        super(indexLayer);
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("users_enabled")).help("Number of enabled users.")).callback(cb -> UserMetricsCollector.wrapInStorageExceptionLogger(cb, (SupplierWithException<Double, StorageException>)((SupplierWithException)() -> ((UserIndex)indexLayer.openGlobalIndex(UserIndex.class)).getEnabledUserCount()))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("users_licensed")).help("Number of licensed users.")).callback(cb -> UserMetricsCollector.wrapInStorageExceptionLogger(cb, (SupplierWithException<Double, StorageException>)((SupplierWithException)() -> {
            if (LicenseManager.getInstance().getLicense() != null) {
                return LicenseManager.getInstance().getLicense().getNumUsers();
            }
            return 0.0;
        }))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("users_active_last_5_minutes")).help("Number of active users in the last 5 minutes")).callback(cb -> this.getActiveUsers((GaugeWithCallback.Callback)cb, Duration.ofMinutes(5L))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("users_active_last_day")).help("Number of active users in the last day")).callback(cb -> this.getActiveUsers((GaugeWithCallback.Callback)cb, Duration.ofDays(1L))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("users_active_last_month")).help("Number of active users in the last month")).callback(cb -> this.getActiveUsers((GaugeWithCallback.Callback)cb, Duration.ofDays(30L))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("users_active_last_quarter")).help("Number of active users in the last quarter")).callback(cb -> this.getActiveUsers((GaugeWithCallback.Callback)cb, Duration.ofDays(90L))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("users_active_last_180_days")).help("Number of active users in the last 180 days")).callback(cb -> this.getActiveUsers((GaugeWithCallback.Callback)cb, Duration.ofDays(180L))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("users_active_last_year")).help("Number of active users in the last year")).callback(cb -> this.getActiveUsers((GaugeWithCallback.Callback)cb, Duration.ofDays(365L))).register();
    }

    private void getActiveUsers(GaugeWithCallback.Callback callback, Duration duration) {
        try {
            List lastActivityTimestamps = ((UserLastActivityIndex)this.indexLayer.openGlobalIndex(UserLastActivityIndex.class)).getLastActivityTimestamps();
            callback.call((double)UsageDataCollector.calculateActiveUsers((TemporalAmount)duration, (List)lastActivityTimestamps), new String[0]);
        }
        catch (StorageException e) {
            LOGGER.error("Could not retrieve active users", (Throwable)e);
        }
    }
}

