/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.parser;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;

@Path(value="api/language-info/{language}")
public class LanguageProcessingInfoService
extends ApiBase {
    @GET
    @Operation(summary="Retrieve the language processing information", description="Returns whether the given language has a shallow parser and a preprocessor.", tags={"Source Code"}, responses={@ApiResponse(responseCode="400", description="Param language must be a language known to teamscale (included in our ELanguages).")})
    @RequiresNoPermission
    public LanguageProcessingInfo getLanguageProcessingInfo(@Parameter(description="The name of the language that we want to check for parser support and preprocessor") @PathParam(value="language") ELanguage language) {
        return new LanguageProcessingInfo(ShallowParserFactory.getSupportedLanguages().contains(language), PreprocessorUtils.hasPreprocessor((ELanguage)language));
    }

    private static class LanguageProcessingInfo {
        private static final String HAS_SHALLOW_PARSER_SUPPORT = "hasShallowSupport";
        private static final String HAS_PREPROCESSOR = "hasPreprocessor";
        @JsonProperty(value="hasShallowSupport")
        public final boolean hasShallowParserSupport;
        @JsonProperty(value="hasPreprocessor")
        public final boolean hasPreprocessor;

        @JsonCreator
        public LanguageProcessingInfo(@JsonProperty(value="hasShallowSupport") boolean hasShallowParserSupport, @JsonProperty(value="hasPreprocessor") boolean hasPreprocessor) {
            this.hasShallowParserSupport = hasShallowParserSupport;
            this.hasPreprocessor = hasPreprocessor;
        }
    }
}

