/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.persistence;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Random;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.statistics.StatisticsCollectingCallback;
import org.conqat.engine.persistence.store.util.ConvenientStore;

@Path(value="api/io-performance")
public class SimpleReadWritePerformanceService
extends ApiBase {
    private static final int NUM_KEYS = 500000;
    private static final int VALUE_SIZE = 1000;
    private static final Random RANDOM = new Random();
    private static final String TEST_STORAGE = "rw-performance-test";

    @GET
    @Operation(summary="Get simple read/write performance statistics", description="Returns a textual summary of read/write performance statistics.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String getReadWriteStatistics() throws StorageException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter responseWriter = new PrintWriter(stringWriter);
        GlobalStorageSystem globalStorageSystem = this.getGlobalStorageSystem();
        ConvenientStore store = new ConvenientStore(globalStorageSystem.openStore(TEST_STORAGE));
        double writeTimeSeconds = (double)SimpleReadWritePerformanceService.measureWriteSpeed(store) / 1000.0;
        for (int i = 0; i < 500000; ++i) {
            store.putWithString("key500000" + i, SimpleReadWritePerformanceService.createRandomValue());
        }
        double readTimeSeconds = (double)SimpleReadWritePerformanceService.measureReadSpeed(store) / 1000.0;
        StatisticsCollectingCallback callback = new StatisticsCollectingCallback();
        store.scan(new byte[0], (IKeyValueCallback)callback);
        long storeSizeMb = (callback.getKeySize() + callback.getValueSize()) / 0x100000L;
        responseWriter.println("Writing/reading " + storeSizeMb + " MBs of random data...");
        responseWriter.println("write speed: " + (int)((double)storeSizeMb / writeTimeSeconds) + " MB/s");
        responseWriter.println("read speed: " + (int)((double)storeSizeMb / readTimeSeconds) + " MB/s");
        globalStorageSystem.removeStore(TEST_STORAGE);
        return stringWriter.toString();
    }

    private static long measureReadSpeed(ConvenientStore store) throws StorageException {
        long start = System.currentTimeMillis();
        for (int j = 0; j < 500000; ++j) {
            store.getWithString("key" + j);
        }
        return System.currentTimeMillis() - start;
    }

    private static long measureWriteSpeed(ConvenientStore store) throws StorageException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 500000; ++i) {
            store.putWithString("key" + i, SimpleReadWritePerformanceService.createRandomValue());
        }
        return System.currentTimeMillis() - start;
    }

    private static byte[] createRandomValue() {
        byte[] value = new byte[1000];
        RANDOM.nextBytes(value);
        return value;
    }
}

