/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.persistence;

import com.teamscale.service.base.ApiBase;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public abstract class StoreExportServiceBase
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    protected String exportStores(String directoryPath, Set<String> storesToWrite, SchemaAwareStorageSystem storageSystem) throws StorageException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        File directory = new File(directoryPath);
        try {
            FileSystemUtils.ensureDirectoryExists((File)directory);
            writer.println("Exporting into " + directory.getAbsolutePath());
            for (String name : storageSystem.getSchema().getEntryNames()) {
                if (!storesToWrite.isEmpty() && !storesToWrite.contains(name)) continue;
                this.writeStore(storageSystem, writer, directory, name);
            }
            writer.close();
        }
        catch (IOException e) {
            writer.println("Failed to write stores to directory " + directory.getAbsolutePath() + ":" + e.getMessage());
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        writer.close();
        return stringWriter.toString();
    }

    private void writeStore(SchemaAwareStorageSystem storageSystem, PrintWriter writer, File directory, String name) throws IOException, StorageException {
        try (DataOutputStream out = new DataOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(new File(directory, name)))));){
            int numEntries = StorageUtils.exportStore((IStore)storageSystem.openStore(name), (DataOutputStream)out);
            writer.println("Wrote " + numEntries + " entries for " + name);
        }
    }
}

