/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.portfolio;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.findings.calculation.BasicFindingsFilterSettings;
import com.teamscale.index.findings.calculation.CodeFindingsRetriever;
import com.teamscale.index.findings.calculation.FindingDeltaCount;
import com.teamscale.index.findings.calculation.FindingDeltaFilterUtils;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.portfolio.EQualityGoal;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.portfolio.PortfolioQualityGoalBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class PortfolioFindingsQualityGoal
extends PortfolioQualityGoalBase {
    @JsonProperty
    private EQualityGoal type;
    @JsonProperty
    private int numberOfStartFindings;
    @JsonProperty
    private int numberOfEndFindings;
    @JsonProperty
    private FindingDeltaCount findingDeltaCount;

    @JsonCreator
    public PortfolioFindingsQualityGoal(ProjectInfo projectInfo, ITeamscaleServiceInfo serviceInfo, EQualityGoal type) throws StorageException {
        super(projectInfo, serviceInfo);
        this.type = type;
    }

    public EQualityGoal getType() {
        return this.type;
    }

    public int getNumberOfStartFindings() {
        return this.numberOfStartFindings;
    }

    public int getNumberOfEndFindings() {
        return this.numberOfEndFindings;
    }

    public FindingDeltaCount getFindingDeltaCount() {
        return this.findingDeltaCount;
    }

    public void calculateFindingsInfo(CommitDescriptor start, CommitDescriptor end) throws StorageException {
        Set<String> blacklistedFindingIds = this.getBlacklistedFindingIds(start, end);
        this.numberOfStartFindings = this.getFilteredFindingsCountAtCommit(start, blacklistedFindingIds);
        this.numberOfEndFindings = this.getFilteredFindingsCountAtCommit(end, blacklistedFindingIds);
        FindingsCalculationInfo calculationInfo = new FindingsCalculationInfo(this.projectInfo.getPrimaryPublicId(), (ProjectStorageSystem)this.getProjectStorageSystem(), this.getIndexLayer());
        this.findingDeltaCount = FindingDeltaFilterUtils.calculateFindingDeltaCountForPath((CommitDescriptor)start, (CommitDescriptor)end, (BasicFindingsFilterSettings)new BasicFindingsFilterSettings(), (UniformPath)UniformPath.codeRoot(), (FindingsCalculationInfo)calculationInfo);
    }

    private int getFilteredFindingsCountAtCommit(CommitDescriptor commit, Set<String> blacklistedFindingIds) throws StorageException {
        CodeFindingsRetriever findingsRetriever = new CodeFindingsRetriever((ProjectStorageSystem)this.getProjectStorageSystem());
        Map findingsById = findingsRetriever.getFindingsById("", commit);
        return CollectionUtils.copyWithEntriesRemoved((Map)findingsById, blacklistedFindingIds).values().size();
    }

    private Set<String> getBlacklistedFindingIds(CommitDescriptor start, CommitDescriptor end) throws StorageException {
        List<FindingBlacklistInfo> blacklistInfosAtStart = this.getFindingBlacklistInfos(start);
        List<FindingBlacklistInfo> blacklistInfosAtEnd = this.getFindingBlacklistInfos(end);
        blacklistInfosAtStart.addAll(blacklistInfosAtEnd);
        return blacklistInfosAtStart.stream().filter(Objects::nonNull).map(FindingBlacklistInfo::getFindingId).collect(Collectors.toSet());
    }

    private List<FindingBlacklistInfo> getFindingBlacklistInfos(CommitDescriptor commit) throws StorageException {
        FindingBlacklistIndex findingBlacklistIndex = (FindingBlacklistIndex)this.getProjectStorageSystem().openProjectIndex(FindingBlacklistIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit));
        return new ArrayList<FindingBlacklistInfo>(findingBlacklistIndex.getAllBlacklistInfos().values());
    }
}

