/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.precommit;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Map;
import org.conqat.engine.index.shared.PreCommit3Result;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

public interface IPreCommit3ServiceApi {
    @PUT
    @Operation(summary="Request pre-commit 3.0 analysis", description="Uploads new change data and analyzes them on a user-specific pre-commit branch. The new content is uploaded as a map from path to new/changed content. To mark deleted files (also after a rename), put null values into the map. The service returns immediately with a list of already calculated findings and an optional pre-commit token that can be used to poll for an updated list of findings given the new file contents. The initial finding response contains already adjusted finding locations with regards to the passed content, this means no location adjustment is needed on the client side. If all file contents match the content on the server, no pre-commit polling token is returned. If pre-commit limits are exceeded, an optional error message is returned, but the current findings are returned as well.", responses={@ApiResponse(responseCode="200", description="Returns the preliminary pre-commit result. Any errors are encoded in the 'error' field of the response.")}, tags={"Pre-Commit"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_7_0)
    public PreCommit3Result requestPreCommitAnalysis(@QueryParam(value="commit") String var1, @QueryParam(value="branch") @Parameter(description="The repository branch that this precommit-request is based on (the branch that the user works on when starting this request)") String var2, @RequestBody(description="The paths and content of added, changed or deleted files. Files are considered deleted if null content is given.", required=true) Map<String, @Nullable String> var3, @QueryParam(value="handleFilePathsCaseInsensitive") @DefaultValue(value="false") boolean var4) throws StorageException;

    @Path(value="{token}")
    @GET
    @Operation(summary="Poll pre-commit 3.0 results", description="Returns exactly the same response as the initial finding request. It may, however, omit the list of findings unless the analysis is ready. If the analysis is ready, the list of findings is returned (may be empty) and the token is empty.", tags={"Pre-Commit"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_7_0)
    public PreCommit3Result pollPreCommitResults(@PathParam(value="token") String var1) throws StorageException;

    @DELETE
    @Operation(summary="Removes pre-commit 3.0 branches", description="Removes data associated with the pre-commit branches created for requests with the given parameters. If the query parameters are omitted, all pre-commit branches for the current user are deleted.", tags={"Pre-Commit"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_7_0)
    public void clearPreCommitBranch(@QueryParam(value="commit") String var1, @QueryParam(value="branch") String var2) throws StorageException;
}

