/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import com.teamscale.service.project.ConnectorDescriptorTransport;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@Path(value="api/connector-descriptors")
public class ConnectorDescriptorService
extends ApiBase {
    @GET
    @RequiresComplexPermission(value=EComplexPermission.MAY_CONFIGURE_PROJECTS)
    @Operation(summary="Get connector descriptors", description="Retrieves connector descriptors available in the system.", tags={"Project"})
    public List<ConnectorDescriptorTransport> getConnectorDescriptors() {
        ArrayList<ConnectorDescriptorTransport> descriptors = new ArrayList<ConnectorDescriptorTransport>();
        for (ConnectorDescriptorBase descriptor2 : ConfigRegistry.getInstance().createAllDescriptors()) {
            descriptors.add(new ConnectorDescriptorTransport(descriptor2));
        }
        descriptors.sort(Comparator.comparing(descriptor -> descriptor.getName().toLowerCase()));
        return descriptors;
    }
}

