/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreator;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.TeamscaleVersionContainer;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.index.backup.EBackupStatus;
import com.teamscale.index.backup.TemporaryFileIndex;
import com.teamscale.index.backup.read.BackupImportOptions;
import com.teamscale.index.backup.read.BackupImportStatus;
import com.teamscale.index.backup.read.BackupReader;
import com.teamscale.index.backup.read.BackupReadingParameters;
import com.teamscale.index.configuration.service.EProjectConfigurationVersion;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.logging.ICriticalEventLogger;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.ZipFile;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.jspecify.annotations.NonNull;

@Path(value="api/projects")
public class ProjectConfigurationImportExportService
extends ApiBase {
    @Context
    private ICriticalEventLogger criticalEventLogger;

    @POST
    @Path(value="import")
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_PROJECTS})
    @Operation(summary="Import project(s)", description="Imports a project(s) into the instance. The given file can either be a project configuration (.tsproject) or a project backup (.zip).", tags={"Project"})
    @Consumes(value={"multipart/form-data"})
    public void importProjectConfiguration(@Parameter(required=true, array=@ArraySchema(schema=@Schema(type="string", format="binary"))) @FormDataParam(value="project-configuration") List<FormDataBodyPart> configurations) throws IOException, StorageException {
        for (FormDataBodyPart configuration : configurations) {
            try (BufferedInputStream stream = new BufferedInputStream((InputStream)configuration.getEntityAs(InputStream.class));){
                ((InputStream)stream).mark(10);
                byte[] header = new byte[4];
                FileSystemUtils.safeRead((InputStream)stream, (byte[])header);
                ((InputStream)stream).reset();
                if (ByteArrayUtils.startsWithZipMagicBytes((byte[])header)) {
                    this.importFromBackupFile(stream);
                    continue;
                }
                this.importFromConfigJson(FileSystemUtils.readStreamBinary((InputStream)stream));
            }
            catch (IOException e) {
                throw new InternalServerErrorException("Failed to process multipart data!", (Throwable)e);
            }
        }
    }

    @GET
    @Path(value="{project}/configuration/export")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Export project configuration", description="Downloads the project configuration which is only the configuration and does not include the project data, analysis profiles or external accounts.", tags={"Project"})
    public Response exportProjectConfiguration() throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfigurationWithoutEmbeddedProfile((ProjectStorageSystem)this.getProjectStorageSystem());
        return ResponseUtils.toFileDownload((Object)projectConfiguration, (Enum)EProjectConfigurationVersion.CURRENT_VERSION, (String)(String.valueOf(this.serviceInfo.getPrimaryPublicId()) + ".tsproject"));
    }

    private void importFromBackupFile(InputStream inputStream) throws StorageException {
        BackupImportStatus backupResult;
        BackupReadingParameters parameters = new BackupReadingParameters(new BackupImportOptions(), this.getIndexLayer(), FileSystemUtils.getTmpDir(), this.serviceInfo.getLockProvider(), this.serviceInfo.getServerConfiguration().toInstanceConfiguration());
        try (ZipFile backupFile = this.getBackupFile(inputStream);){
            backupResult = BackupReader.importBackupData((ZipFile)backupFile, (BackupReadingParameters)parameters, (ICancelable)ICancelable.neverCanceled(), (IParallelTaskExecutor)this.getParallelTaskExecutor());
        }
        catch (IOException e) {
            throw new StorageException("Unable to load backup file", (Throwable)e);
        }
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        for (PublicProjectId project : backupResult.getImportedProjects()) {
            ProjectInfo projectInfo = projectIndex.resolveProject((IProjectId)project);
            this.getPermissions().createPermissionModifier().makeCurrentUserProjectAdmin(projectInfo);
            this.criticalEventLogger.logCriticalEventMessage((IProjectId)project, "Project import event");
        }
        ProjectConfigurationImportExportService.handleImportFailure(backupResult);
    }

    private @NonNull ZipFile getBackupFile(InputStream inputStream) throws StorageException {
        TemporaryFileIndex temporaryFileIndex = this.openGlobalIndex(TemporaryFileIndex.class);
        String temporaryFileName = temporaryFileIndex.getTemporaryFileName();
        try (InputStream inputStream2 = inputStream;
             OutputStream outputStream = temporaryFileIndex.writeFile(temporaryFileName);){
            FileSystemUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new StorageException("Unable to write backup to temporary file index", (Throwable)e);
        }
        try {
            return new ZipFile(temporaryFileIndex.openReadChannel(temporaryFileName), temporaryFileName);
        }
        catch (IOException e) {
            throw new StorageException("Unable to read backup from temporary file index", (Throwable)e);
        }
    }

    private static void handleImportFailure(BackupImportStatus status) {
        for (BackupImportStatus.ImportProgress progress : status.getProjectProgress()) {
            if (progress.getStatus() != EBackupStatus.FAILURE) continue;
            throw new BadRequestException(ProjectConfigurationImportExportService.buildStatusMessage("Project " + String.valueOf(progress.getProject()) + ": " + progress.getStatusMessage(), progress.getLogs()));
        }
        if (status.getStatus() == EBackupStatus.FAILURE) {
            throw new BadRequestException(ProjectConfigurationImportExportService.buildStatusMessage(status.getStatusMessage(), status.getLogs()));
        }
    }

    private static String buildStatusMessage(String message, List<LoggingEventTransport> logs) {
        StringBuilder messageBuilder = new StringBuilder(message);
        for (LoggingEventTransport log : logs) {
            messageBuilder.append("\n").append(log.getLevel()).append(": ").append(log.getMessage());
        }
        return messageBuilder.toString();
    }

    private void importFromConfigJson(byte[] data) throws StorageException {
        try {
            ProjectConfiguration projectConfiguration = (ProjectConfiguration)TeamscaleVersionContainer.fromJson((byte[])data, null, ProjectConfiguration.class, (Enum)EProjectConfigurationVersion.CURRENT_VERSION, (String)"project configuration");
            new ProjectCreator(this.getIndexLayer(), this.getUser().getUsername(), ConfigurationInitializationContext.EInitializationReason.PROJECT_CREATION).createProject(projectConfiguration);
            ProjectInfo projectInfo = (ProjectInfo)this.openGlobalIndex(ProjectIndex.class).getProjectWithoutPublicIdResolution(projectConfiguration.getInternalId()).orElseThrow();
            this.getPermissions().createPermissionModifier().makeCurrentUserProjectAdmin(projectInfo);
            this.criticalEventLogger.logCriticalEventMessage((IProjectId)projectInfo.getInternalId(), "Project import event");
        }
        catch (ProjectConfigurationException | MigrationException | TriggerCompilationException e) {
            throw new InternalServerErrorException("Error creating project: " + e.getMessage(), e);
        }
    }
}

