/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.user.ProjectUserActivityIndex;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.project.IProjectUserActivityServiceApi;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/unique-project-users")
public class ProjectUserActivityService
extends ApiBase
implements IProjectUserActivityServiceApi {
    @Override
    public Integer getNumberOfUniqueUsers(List<String> projects, Long startTimestamp, long endTimestamp, List<String> excludedGroupsParameter) throws StorageException {
        List projectIds = PublicProjectId.of(projects);
        ProjectUserActivityIndex projectUsersIndex = this.openGlobalIndex(ProjectUserActivityIndex.class);
        return ProjectUserActivityService.processAggregatedQuery(startTimestamp, endTimestamp, projectIds, projectUsersIndex, this.getExcludedUsers(excludedGroupsParameter));
    }

    @Override
    public List<List<Number>> getProjectUserActivityTrend(List<String> projects, Long startTimestamp, long endTimestamp, List<String> excludedGroupsParameter) throws StorageException {
        List projectIds = PublicProjectId.of(projects);
        ProjectUserActivityIndex projectUsersIndex = this.openGlobalIndex(ProjectUserActivityIndex.class);
        return ProjectUserActivityService.processTrendQuery(startTimestamp, endTimestamp, projectIds, projectUsersIndex, this.getExcludedUsers(excludedGroupsParameter));
    }

    private Set<String> getExcludedUsers(List<String> excludedGroupsParameter) throws StorageException {
        List excludedGroups = CollectionUtils.emptyIfNull(excludedGroupsParameter);
        UserGroupIndex groupIndex = this.openGlobalIndex(UserGroupIndex.class);
        List userGroups = groupIndex.getUserGroups(excludedGroups);
        HashSet<String> excludedUsers = new HashSet<String>();
        for (UserGroup group : userGroups) {
            excludedUsers.addAll((Collection<String>)group.getUserNames());
        }
        return excludedUsers;
    }

    private static List<List<Number>> processTrendQuery(long startTimestamp, long endTimestamp, List<PublicProjectId> projects, ProjectUserActivityIndex projectUsersIndex, Set<String> excludedUsers) throws StorageException {
        List<Instant> days;
        Instant startDay = Instant.ofEpochMilli(startTimestamp).truncatedTo(ChronoUnit.DAYS);
        if (endTimestamp == -1L) {
            days = Collections.singletonList(startDay);
        } else {
            if (endTimestamp < startTimestamp) {
                throw new BadRequestException("The given end timestamp is not after the given baseline.");
            }
            days = ProjectUserActivityService.getTrendDays(startTimestamp, endTimestamp);
        }
        ArrayList<List<Number>> result = new ArrayList<List<Number>>(days.size());
        for (Instant day : days) {
            Integer uniqueUsers = projectUsersIndex.getNumberOfUniqueUsers(projects, day, day.plus(1L, ChronoUnit.DAYS), excludedUsers);
            result.add(Arrays.asList(day.toEpochMilli(), uniqueUsers));
        }
        return result;
    }

    private static Integer processAggregatedQuery(long startTimestamp, long endTimestamp, List<PublicProjectId> projects, ProjectUserActivityIndex projectUsersIndex, Set<String> excludedUsers) throws StorageException {
        Instant startInstant = Instant.ofEpochMilli(startTimestamp);
        Instant endInstant = Instant.ofEpochMilli(endTimestamp).plus(1L, ChronoUnit.DAYS);
        return projectUsersIndex.getNumberOfUniqueUsers(projects, startInstant, endInstant, excludedUsers);
    }

    private static List<Instant> getTrendDays(long startTimestamp, long endTimestamp) {
        Instant startDay = Instant.ofEpochMilli(startTimestamp).truncatedTo(ChronoUnit.DAYS);
        Instant endDay = Instant.ofEpochMilli(endTimestamp).truncatedTo(ChronoUnit.DAYS);
        ArrayList<Instant> days = new ArrayList<Instant>();
        while (!startDay.isAfter(endDay)) {
            days.add(startDay);
            startDay = startDay.plus(1L, ChronoUnit.DAYS);
        }
        return days;
    }
}

