/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

@Path(value="api/project-connectors")
public class ProjectsConnectorsService
extends ApiBase {
    @GET
    @Operation(summary="Returns all projects' connectors", description="Returns information about the connector configurations associated with each project by its ID (not alias). The service returns the connector configurations only for projects visible to the user and thus no permissions are required.")
    @RequiresNoPermission
    public Map<String, List<ConnectorConfiguration>> getProjectsConnectors() throws StorageException, ExecutionException, InterruptedException {
        List visibleProjects = this.serviceInfo.getPermissions().getVisibleProjects(true, true);
        IndexLayer indexLayer = this.getIndexLayer();
        return (Map)this.getParallelTaskExecutor().computeInParallel((Collection)visibleProjects, project -> ProjectsConnectorsService.getProjectConnectors(indexLayer, project), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map.Entry<String, List<ConnectorConfiguration>> getProjectConnectors(IndexLayer indexLayer, ProjectInfo project) {
        try {
            ProjectConfiguration configuration = ProjectUtils.retrieveProjectConfig((ProjectInfo)project, (IndexLayer)indexLayer);
            if (configuration != null) {
                return Map.entry(project.getPrimaryPublicId().toString(), configuration.getConnectors());
            }
        }
        catch (StorageException e) {
            LogManager.getLogger().error("Error retrieving project configuration for " + String.valueOf(project) + ": " + String.valueOf((Object)e) + ". This may indicate an incomplete project deletion. You can force delete incompletely deleted projects with the force-delete option of the project delete service.", (Throwable)e);
        }
        return Map.entry(project.getPrimaryPublicId().toString(), Collections.emptyList());
    }

    @GET
    @Path(value="{projectId}")
    @Operation(summary="Returns all connectors for a project", description="Returns information about the connector configurations associated with the project.")
    @RequiresComplexPermission(value=EComplexPermission.MAY_CONFIGURE_PROJECTS)
    public List<ConnectorConfiguration> getConnectors(@Parameter(description="The project id.") @PathParam(value="projectId") PublicProjectId projectId) throws StorageException {
        ProjectIndex projectIndex = (ProjectIndex)this.getGlobalStorageSystem().openGlobalIndex(ProjectIndex.class);
        ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((IProjectId)projectIndex.resolveToInternalId((IProjectId)projectId), (IndexLayer)this.getIndexLayer());
        CCSMAssert.isNotNull((Object)projectConfiguration);
        return projectConfiguration.getConnectors();
    }
}

