/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.wizard;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.project.wizard.ImportWizardRegistry;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Comparator;
import java.util.List;
import org.jspecify.annotations.Nullable;

@Path(value="api/import-wizard")
public class ImportWizardService
extends ApiBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.BACKUP})
    @Operation(summary="Get available sample projects", description="Returns a list of sample projects that can be used as starting point.", tags={"Project"})
    public List<Backup> getBackupsForImportWizard() {
        return ImportWizardRegistry.getAvailableBackups().values().stream().sorted(Comparator.comparing(Backup::title)).toList();
    }

    public record Backup(@JsonProperty(value="title") String title, @JsonProperty(value="description") String description, @JsonProperty(value="backup") String backup, @JsonProperty(value="languages") List<ELanguage> languages, @JsonProperty(value="logo") @Nullable String logo, ImportWizardRegistry.EProjectType projectType) {
    }
}

